@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property address The physical address.
 * @property latitude The latitude.
 * @property longitude The longitude.
 */
public data class DeviceLocation(
    public val address: String? = null,
    public val latitude: String? = null,
    public val longitude: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.networkmanager.outputs.DeviceLocation):
            DeviceLocation = DeviceLocation(
            address = javaType.address().map({ args0 -> args0 }).orElse(null),
            latitude = javaType.latitude().map({ args0 -> args0 }).orElse(null),
            longitude = javaType.longitude().map({ args0 -> args0 }).orElse(null),
        )
    }
}
