@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property action Action to take when a condition is true. Detailed Below.
 * @property conditionLogic Valid values include `and` or `or`. This is a mandatory parameter only if you have more than one condition. The `condition_logic` apply to all of the conditions for a rule, which also means nested conditions of `and` or `or` are not supported. Use `or` if you want to associate the attachment with the segment by either the segment name or attachment tag value, or by the chosen conditions. Use `and` if you want to associate the attachment with the segment by either the segment name or attachment tag value and by the chosen conditions. Detailed Below.
 * @property conditions A block argument. Detailed Below.
 * @property description A user-defined description that further helps identify the rule.
 * @property ruleNumber An integer from `1` to `65535` indicating the rule's order number. Rules are processed in order from the lowest numbered rule to the highest. Rules stop processing when a rule is matched. It's important to make sure that you number your rules in the exact order that you want them processed.
 */
public data class GetCoreNetworkPolicyDocumentAttachmentPolicy(
    public val action: GetCoreNetworkPolicyDocumentAttachmentPolicyAction,
    public val conditionLogic: String? = null,
    public val conditions: List<GetCoreNetworkPolicyDocumentAttachmentPolicyCondition>,
    public val description: String? = null,
    public val ruleNumber: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.networkmanager.outputs.GetCoreNetworkPolicyDocumentAttachmentPolicy):
            GetCoreNetworkPolicyDocumentAttachmentPolicy = GetCoreNetworkPolicyDocumentAttachmentPolicy(
            action = javaType.action().let({ args0 ->
                com.pulumi.aws.networkmanager.kotlin.outputs.GetCoreNetworkPolicyDocumentAttachmentPolicyAction.Companion.toKotlin(args0)
            }),
            conditionLogic = javaType.conditionLogic().map({ args0 -> args0 }).orElse(null),
            conditions = javaType.conditions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.networkmanager.kotlin.outputs.GetCoreNetworkPolicyDocumentAttachmentPolicyCondition.Companion.toKotlin(args0)
                })
            }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            ruleNumber = javaType.ruleNumber(),
        )
    }
}
