@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property associationMethod Defines how a segment is mapped. Values can be `constant` or `tag`. `constant` statically defines the segment to associate the attachment to. `tag` uses the value of a tag to dynamically try to map to a segment.reference_policies_elements_condition_operators.html) to evaluate.
 * @property requireAcceptance Determines if this mapping should override the segment value for `require_attachment_acceptance`. You can only set this to `true`, indicating that this setting applies only to segments that have `require_attachment_acceptance` set to `false`. If the segment already has the default `require_attachment_acceptance`, you can set this to inherit segment’s acceptance value.
 * @property segment Name of the `segment` to share as defined in the `segments` section. This is used only when the `association_method` is `constant`.
 * @property tagValueOfKey Maps the attachment to the value of a known key. This is used with the `association_method` is `tag`. For example a `tag` of `stage = “test”`, will map to a segment named `test`. The value must exactly match the name of a segment. This allows you to have many segments, but use only a single rule without having to define multiple nearly identical conditions. This prevents creating many similar conditions that all use the same keys to map to segments.
 */
public data class GetCoreNetworkPolicyDocumentAttachmentPolicyAction(
    public val associationMethod: String,
    public val requireAcceptance: Boolean? = null,
    public val segment: String? = null,
    public val tagValueOfKey: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.networkmanager.outputs.GetCoreNetworkPolicyDocumentAttachmentPolicyAction):
            GetCoreNetworkPolicyDocumentAttachmentPolicyAction =
            GetCoreNetworkPolicyDocumentAttachmentPolicyAction(
                associationMethod = javaType.associationMethod(),
                requireAcceptance = javaType.requireAcceptance().map({ args0 -> args0 }).orElse(null),
                segment = javaType.segment().map({ args0 -> args0 }).orElse(null),
                tagValueOfKey = javaType.tagValueOfKey().map({ args0 -> args0 }).orElse(null),
            )
    }
}
