@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property asnRanges List of strings containing Autonomous System Numbers (ASNs) to assign to Core Network Edges. By default, the core network automatically assigns an ASN for each Core Network Edge but you can optionally define the ASN in the edge-locations for each Region. The ASN uses an array of integer ranges only from `64512` to `65534` and `4200000000` to `4294967294` expressed as a string like `"64512-65534"`. No other ASN ranges can be used.
 * @property edgeLocations A block value of AWS Region locations where you're creating Core Network Edges. Detailed below.
 * @property insideCidrBlocks The Classless Inter-Domain Routing (CIDR) block range used to create tunnels for AWS Transit Gateway Connect. The format is standard AWS CIDR range (for example, `10.0.1.0/24`). You can optionally define the inside CIDR in the Core Network Edges section per Region. The minimum is a `/24` for IPv4 or `/64` for IPv6. You can provide multiple `/24` subnets or a larger CIDR range. If you define a larger CIDR range, new Core Network Edges will be automatically assigned `/24` and `/64` subnets from the larger CIDR. an Inside CIDR block is required for attaching Connect attachments to a Core Network Edge.
 * @property vpnEcmpSupport Indicates whether the core network forwards traffic over multiple equal-cost routes using VPN. The value can be either `true` or `false`. The default is `true`.
 */
public data class GetCoreNetworkPolicyDocumentCoreNetworkConfiguration(
    public val asnRanges: List<String>,
    public val edgeLocations: List<GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocation>,
    public val insideCidrBlocks: List<String>? = null,
    public val vpnEcmpSupport: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.networkmanager.outputs.GetCoreNetworkPolicyDocumentCoreNetworkConfiguration):
            GetCoreNetworkPolicyDocumentCoreNetworkConfiguration =
            GetCoreNetworkPolicyDocumentCoreNetworkConfiguration(
                asnRanges = javaType.asnRanges().map({ args0 -> args0 }),
                edgeLocations = javaType.edgeLocations().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.networkmanager.kotlin.outputs.GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocation.Companion.toKotlin(args0)
                    })
                }),
                insideCidrBlocks = javaType.insideCidrBlocks().map({ args0 -> args0 }),
                vpnEcmpSupport = javaType.vpnEcmpSupport().map({ args0 -> args0 }).orElse(null),
            )
    }
}
