@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getCoreNetworkPolicyDocument.
 * @property attachmentPolicies
 * @property coreNetworkConfigurations
 * @property id The provider-assigned unique ID for this managed resource.
 * @property json Standard JSON policy document rendered based on the arguments above.
 * @property segmentActions
 * @property segments
 * @property version
 */
public data class GetCoreNetworkPolicyDocumentResult(
    public val attachmentPolicies: List<GetCoreNetworkPolicyDocumentAttachmentPolicy>? = null,
    public val coreNetworkConfigurations: List<GetCoreNetworkPolicyDocumentCoreNetworkConfiguration>,
    public val id: String,
    public val json: String,
    public val segmentActions: List<GetCoreNetworkPolicyDocumentSegmentAction>? = null,
    public val segments: List<GetCoreNetworkPolicyDocumentSegment>,
    public val version: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.networkmanager.outputs.GetCoreNetworkPolicyDocumentResult):
            GetCoreNetworkPolicyDocumentResult = GetCoreNetworkPolicyDocumentResult(
            attachmentPolicies = javaType.attachmentPolicies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.networkmanager.kotlin.outputs.GetCoreNetworkPolicyDocumentAttachmentPolicy.Companion.toKotlin(args0)
                })
            }),
            coreNetworkConfigurations = javaType.coreNetworkConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.networkmanager.kotlin.outputs.GetCoreNetworkPolicyDocumentCoreNetworkConfiguration.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            json = javaType.json(),
            segmentActions = javaType.segmentActions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.networkmanager.kotlin.outputs.GetCoreNetworkPolicyDocumentSegmentAction.Companion.toKotlin(args0)
                })
            }),
            segments = javaType.segments().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.networkmanager.kotlin.outputs.GetCoreNetworkPolicyDocumentSegment.Companion.toKotlin(args0)
                })
            }),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
