@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property action Action to take for the chosen segment. Valid values `create-route` or `share`.
 * @property description A user-defined string describing the segment action.
 * @property destinationCidrBlocks List of strings containing CIDRs. You can define the IPv4 and IPv6 CIDR notation for each AWS Region. For example, `10.1.0.0/16` or `2001:db8::/56`. This is an array of CIDR notation strings.
 * @property destinations A list of strings. Valid values include `["blackhole"]` or a list of attachment ids.
 * @property mode String. This mode places the attachment and return routes in each of the `share_with` segments. Valid values include: `attachment-route`.
 * @property segment Name of the segment.
 * @property shareWithExcepts A set subtraction of segments to not share with.
 * @property shareWiths A list of strings to share with. Must be a substring is all segments. Valid values include: `["*"]` or `["<segment-names>"]`.
 */
public data class GetCoreNetworkPolicyDocumentSegmentAction(
    public val action: String,
    public val description: String? = null,
    public val destinationCidrBlocks: List<String>? = null,
    public val destinations: List<String>? = null,
    public val mode: String? = null,
    public val segment: String,
    public val shareWithExcepts: List<String>? = null,
    public val shareWiths: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.networkmanager.outputs.GetCoreNetworkPolicyDocumentSegmentAction):
            GetCoreNetworkPolicyDocumentSegmentAction = GetCoreNetworkPolicyDocumentSegmentAction(
            action = javaType.action(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            destinationCidrBlocks = javaType.destinationCidrBlocks().map({ args0 -> args0 }),
            destinations = javaType.destinations().map({ args0 -> args0 }),
            mode = javaType.mode().map({ args0 -> args0 }).orElse(null),
            segment = javaType.segment(),
            shareWithExcepts = javaType.shareWithExcepts().map({ args0 -> args0 }),
            shareWiths = javaType.shareWiths().map({ args0 -> args0 }),
        )
    }
}
