@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getDevices.
 * @property globalNetworkId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids IDs of the devices.
 * @property siteId
 * @property tags
 */
public data class GetDevicesResult(
    public val globalNetworkId: String,
    public val id: String,
    public val ids: List<String>,
    public val siteId: String? = null,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.networkmanager.outputs.GetDevicesResult):
            GetDevicesResult = GetDevicesResult(
            globalNetworkId = javaType.globalNetworkId(),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            siteId = javaType.siteId().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
