@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property address Address of the location.
 * @property latitude Latitude of the location.
 * @property longitude Longitude of the location.
 */
public data class GetSiteLocation(
    public val address: String,
    public val latitude: String,
    public val longitude: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.networkmanager.outputs.GetSiteLocation):
            GetSiteLocation = GetSiteLocation(
            address = javaType.address(),
            latitude = javaType.latitude(),
            longitude = javaType.longitude(),
        )
    }
}
