@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getSite.
 * @property arn ARN of the site.
 * @property description Description of the site.
 * @property globalNetworkId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property locations Site location as documented below.
 * @property siteId
 * @property tags Key-value tags for the Site.
 */
public data class GetSiteResult(
    public val arn: String,
    public val description: String,
    public val globalNetworkId: String,
    public val id: String,
    public val locations: List<GetSiteLocation>,
    public val siteId: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.networkmanager.outputs.GetSiteResult):
            GetSiteResult = GetSiteResult(
            arn = javaType.arn(),
            description = javaType.description(),
            globalNetworkId = javaType.globalNetworkId(),
            id = javaType.id(),
            locations = javaType.locations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.networkmanager.kotlin.outputs.GetSiteLocation.Companion.toKotlin(args0)
                })
            }),
            siteId = javaType.siteId(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
