@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property downloadSpeed Download speed in Mbps.
 * @property uploadSpeed Upload speed in Mbps.
 */
public data class LinkBandwidth(
    public val downloadSpeed: Int? = null,
    public val uploadSpeed: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.networkmanager.outputs.LinkBandwidth):
            LinkBandwidth = LinkBandwidth(
            downloadSpeed = javaType.downloadSpeed().map({ args0 -> args0 }).orElse(null),
            uploadSpeed = javaType.uploadSpeed().map({ args0 -> args0 }).orElse(null),
        )
    }
}
