@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property applianceModeSupport Indicates whether appliance mode is supported.
 * If enabled, traffic flow between a source and destination use the same Availability Zone for the VPC attachment for the lifetime of that flow.
 * If the VPC attachment is pending acceptance, changing this value will recreate the resource.
 * @property ipv6Support Indicates whether IPv6 is supported.
 * If the VPC attachment is pending acceptance, changing this value will recreate the resource.
 */
public data class VpcAttachmentOptions(
    public val applianceModeSupport: Boolean? = null,
    public val ipv6Support: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.networkmanager.outputs.VpcAttachmentOptions):
            VpcAttachmentOptions = VpcAttachmentOptions(
            applianceModeSupport = javaType.applianceModeSupport().map({ args0 -> args0 }).orElse(null),
            ipv6Support = javaType.ipv6Support().map({ args0 -> args0 }).orElse(null),
        )
    }
}
