@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.oam.kotlin

import com.pulumi.aws.oam.LinkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS CloudWatch Observability Access Manager Link.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.oam.Link;
 * import com.pulumi.aws.oam.LinkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Link("example", LinkArgs.builder()
 *             .labelTemplate("$AccountName")
 *             .resourceTypes("AWS::CloudWatch::Metric")
 *             .sinkIdentifier(aws_oam_sink.test().id())
 *             .tags(Map.of("Env", "prod"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CloudWatch Observability Access Manager Link using the `arn`. For example:
 * ```sh
 *  $ pulumi import aws:oam/link:Link example arn:aws:oam:us-west-2:123456789012:link/link-id
 * ```
 * @property labelTemplate Human-readable name to use to identify this source account when you are viewing data from it in the monitoring account.
 * @property resourceTypes Types of data that the source account shares with the monitoring account.
 * @property sinkIdentifier Identifier of the sink to use to create this link.
 * The following arguments are optional:
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class LinkArgs(
    public val labelTemplate: Output<String>? = null,
    public val resourceTypes: Output<List<String>>? = null,
    public val sinkIdentifier: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.oam.LinkArgs> {
    override fun toJava(): com.pulumi.aws.oam.LinkArgs = com.pulumi.aws.oam.LinkArgs.builder()
        .labelTemplate(labelTemplate?.applyValue({ args0 -> args0 }))
        .resourceTypes(resourceTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
        .sinkIdentifier(sinkIdentifier?.applyValue({ args0 -> args0 }))
        .tags(
            tags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [LinkArgs].
 */
@PulumiTagMarker
public class LinkArgsBuilder internal constructor() {
    private var labelTemplate: Output<String>? = null

    private var resourceTypes: Output<List<String>>? = null

    private var sinkIdentifier: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Human-readable name to use to identify this source account when you are viewing data from it in the monitoring account.
     */
    @JvmName("fsmdcsbdkvujtdao")
    public suspend fun labelTemplate(`value`: Output<String>) {
        this.labelTemplate = value
    }

    /**
     * @param value Types of data that the source account shares with the monitoring account.
     */
    @JvmName("uwvqoebrlsagkixs")
    public suspend fun resourceTypes(`value`: Output<List<String>>) {
        this.resourceTypes = value
    }

    @JvmName("eqabxntaymxvkgnp")
    public suspend fun resourceTypes(vararg values: Output<String>) {
        this.resourceTypes = Output.all(values.asList())
    }

    /**
     * @param values Types of data that the source account shares with the monitoring account.
     */
    @JvmName("acdtfaofvestnufr")
    public suspend fun resourceTypes(values: List<Output<String>>) {
        this.resourceTypes = Output.all(values)
    }

    /**
     * @param value Identifier of the sink to use to create this link.
     * The following arguments are optional:
     */
    @JvmName("ehghmlpkuwqkvoac")
    public suspend fun sinkIdentifier(`value`: Output<String>) {
        this.sinkIdentifier = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("awcfbgekixpjakss")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Human-readable name to use to identify this source account when you are viewing data from it in the monitoring account.
     */
    @JvmName("skplwoygfgfgeykc")
    public suspend fun labelTemplate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labelTemplate = mapped
    }

    /**
     * @param value Types of data that the source account shares with the monitoring account.
     */
    @JvmName("jivwxqenjqemvayh")
    public suspend fun resourceTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceTypes = mapped
    }

    /**
     * @param values Types of data that the source account shares with the monitoring account.
     */
    @JvmName("pcnwnrfxapmsfxlj")
    public suspend fun resourceTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceTypes = mapped
    }

    /**
     * @param value Identifier of the sink to use to create this link.
     * The following arguments are optional:
     */
    @JvmName("ddusctfxkkjajufv")
    public suspend fun sinkIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sinkIdentifier = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("maohtymalignssbm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kmfbxxiytorpcfou")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): LinkArgs = LinkArgs(
        labelTemplate = labelTemplate,
        resourceTypes = resourceTypes,
        sinkIdentifier = sinkIdentifier,
        tags = tags,
    )
}
