@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.oam.kotlin

import com.pulumi.aws.oam.OamFunctions.getLinkPlain
import com.pulumi.aws.oam.OamFunctions.getLinksPlain
import com.pulumi.aws.oam.OamFunctions.getSinkPlain
import com.pulumi.aws.oam.OamFunctions.getSinksPlain
import com.pulumi.aws.oam.kotlin.inputs.GetLinkPlainArgs
import com.pulumi.aws.oam.kotlin.inputs.GetLinkPlainArgsBuilder
import com.pulumi.aws.oam.kotlin.inputs.GetSinkPlainArgs
import com.pulumi.aws.oam.kotlin.inputs.GetSinkPlainArgsBuilder
import com.pulumi.aws.oam.kotlin.outputs.GetLinkResult
import com.pulumi.aws.oam.kotlin.outputs.GetLinksResult
import com.pulumi.aws.oam.kotlin.outputs.GetSinkResult
import com.pulumi.aws.oam.kotlin.outputs.GetSinksResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.oam.kotlin.outputs.GetLinkResult.Companion.toKotlin as getLinkResultToKotlin
import com.pulumi.aws.oam.kotlin.outputs.GetLinksResult.Companion.toKotlin as getLinksResultToKotlin
import com.pulumi.aws.oam.kotlin.outputs.GetSinkResult.Companion.toKotlin as getSinkResultToKotlin
import com.pulumi.aws.oam.kotlin.outputs.GetSinksResult.Companion.toKotlin as getSinksResultToKotlin

public object OamFunctions {
    /**
     * Data source for managing an AWS CloudWatch Observability Access Manager Link.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.oam.OamFunctions;
     * import com.pulumi.aws.oam.inputs.GetLinkArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = OamFunctions.getLink(GetLinkArgs.builder()
     *             .linkIdentifier("arn:aws:oam:us-west-1:111111111111:link/abcd1234-a123-456a-a12b-a123b456c789")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getLink.
     * @return A collection of values returned by getLink.
     */
    public suspend fun getLink(argument: GetLinkPlainArgs): GetLinkResult =
        getLinkResultToKotlin(getLinkPlain(argument.toJava()).await())

    /**
     * @see [getLink].
     * @param linkIdentifier ARN of the link.
     * @param tags
     * @return A collection of values returned by getLink.
     */
    public suspend fun getLink(linkIdentifier: String, tags: Map<String, String>? = null):
        GetLinkResult {
        val argument = GetLinkPlainArgs(
            linkIdentifier = linkIdentifier,
            tags = tags,
        )
        return getLinkResultToKotlin(getLinkPlain(argument.toJava()).await())
    }

    /**
     * @see [getLink].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;oam&#46;kotlin&#46;inputs&#46;GetLinkPlainArgs].
     * @return A collection of values returned by getLink.
     */
    public suspend fun getLink(argument: suspend GetLinkPlainArgsBuilder.() -> Unit): GetLinkResult {
        val builder = GetLinkPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLinkResultToKotlin(getLinkPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing an AWS CloudWatch Observability Access Manager Links.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.oam.OamFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = OamFunctions.getLinks();
     *     }
     * }
     * ```
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.oam.OamFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = OamFunctions.getLinks();
     *     }
     * }
     * ```
     * @param argument Data source for managing an AWS CloudWatch Observability Access Manager Links.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.oam.OamFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = OamFunctions.getLinks();
     *     }
     * }
     * ```
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.oam.OamFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = OamFunctions.getLinks();
     *     }
     * }
     * ```
     * @return A collection of values returned by getLinks.
     */
    public suspend fun getLinks(): GetLinksResult = getLinksResultToKotlin(getLinksPlain().await())

    /**
     * Data source for managing an AWS CloudWatch Observability Access Manager Sink.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.oam.OamFunctions;
     * import com.pulumi.aws.oam.inputs.GetSinkArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = OamFunctions.getSink(GetSinkArgs.builder()
     *             .sinkIdentifier("arn:aws:oam:us-west-1:111111111111:sink/abcd1234-a123-456a-a12b-a123b456c789")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getSink.
     * @return A collection of values returned by getSink.
     */
    public suspend fun getSink(argument: GetSinkPlainArgs): GetSinkResult =
        getSinkResultToKotlin(getSinkPlain(argument.toJava()).await())

    /**
     * @see [getSink].
     * @param sinkIdentifier ARN of the sink.
     * @param tags Tags assigned to the sink.
     * @return A collection of values returned by getSink.
     */
    public suspend fun getSink(sinkIdentifier: String, tags: Map<String, String>? = null):
        GetSinkResult {
        val argument = GetSinkPlainArgs(
            sinkIdentifier = sinkIdentifier,
            tags = tags,
        )
        return getSinkResultToKotlin(getSinkPlain(argument.toJava()).await())
    }

    /**
     * @see [getSink].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;oam&#46;kotlin&#46;inputs&#46;GetSinkPlainArgs].
     * @return A collection of values returned by getSink.
     */
    public suspend fun getSink(argument: suspend GetSinkPlainArgsBuilder.() -> Unit): GetSinkResult {
        val builder = GetSinkPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSinkResultToKotlin(getSinkPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing an AWS CloudWatch Observability Access Manager Sinks.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.oam.OamFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = OamFunctions.getSinks();
     *     }
     * }
     * ```
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.oam.OamFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = OamFunctions.getSinks();
     *     }
     * }
     * ```
     * @param argument Data source for managing an AWS CloudWatch Observability Access Manager Sinks.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.oam.OamFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = OamFunctions.getSinks();
     *     }
     * }
     * ```
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.oam.OamFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = OamFunctions.getSinks();
     *     }
     * }
     * ```
     * @return A collection of values returned by getSinks.
     */
    public suspend fun getSinks(): GetSinksResult = getSinksResultToKotlin(getSinksPlain().await())
}
