@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.oam.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SinkPolicy].
 */
@PulumiTagMarker
public class SinkPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SinkPolicyArgs = SinkPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SinkPolicyArgsBuilder.() -> Unit) {
        val builder = SinkPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SinkPolicy {
        val builtJavaResource = com.pulumi.aws.oam.SinkPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SinkPolicy(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS CloudWatch Observability Access Manager Sink Policy.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.oam.Sink;
 * import com.pulumi.aws.oam.SinkPolicy;
 * import com.pulumi.aws.oam.SinkPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleSink = new Sink("exampleSink");
 *         var exampleSinkPolicy = new SinkPolicy("exampleSinkPolicy", SinkPolicyArgs.builder()
 *             .sinkIdentifier(exampleSink.id())
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", jsonArray(
 *                             "oam:CreateLink",
 *                             "oam:UpdateLink"
 *                         )),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Resource", "*"),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("AWS", jsonArray(
 *                                 "1111111111111",
 *                                 "222222222222"
 *                             ))
 *                         )),
 *                         jsonProperty("Condition", jsonObject(
 *                             jsonProperty("ForAllValues:StringEquals", jsonObject(
 *                                 jsonProperty("oam:ResourceTypes", jsonArray(
 *                                     "AWS::CloudWatch::Metric",
 *                                     "AWS::Logs::LogGroup"
 *                                 ))
 *                             ))
 *                         ))
 *                     )))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CloudWatch Observability Access Manager Sink Policy using the `sink_identifier`. For example:
 * ```sh
 *  $ pulumi import aws:oam/sinkPolicy:SinkPolicy example arn:aws:oam:us-west-2:123456789012:sink/sink-id
 * ```
 *
 */
public class SinkPolicy internal constructor(
    override val javaResource: com.pulumi.aws.oam.SinkPolicy,
) : KotlinCustomResource(javaResource, SinkPolicyMapper) {
    /**
     * ARN of the Sink.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * JSON policy to use. If you are updating an existing policy, the entire existing policy is replaced by what you specify here.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })

    /**
     * ID string that AWS generated as part of the sink ARN.
     */
    public val sinkId: Output<String>
        get() = javaResource.sinkId().applyValue({ args0 -> args0 })

    /**
     * ARN of the sink to attach this policy to.
     */
    public val sinkIdentifier: Output<String>
        get() = javaResource.sinkIdentifier().applyValue({ args0 -> args0 })
}

public object SinkPolicyMapper : ResourceMapper<SinkPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.oam.SinkPolicy::class == javaResource::class

    override fun map(javaResource: Resource): SinkPolicy = SinkPolicy(
        javaResource as
            com.pulumi.aws.oam.SinkPolicy,
    )
}

/**
 * @see [SinkPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SinkPolicy].
 */
public suspend fun sinkPolicy(name: String, block: suspend SinkPolicyResourceBuilder.() -> Unit):
    SinkPolicy {
    val builder = SinkPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SinkPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sinkPolicy(name: String): SinkPolicy {
    val builder = SinkPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
