@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.oam.kotlin

import com.pulumi.aws.oam.SinkPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS CloudWatch Observability Access Manager Sink Policy.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.oam.Sink;
 * import com.pulumi.aws.oam.SinkPolicy;
 * import com.pulumi.aws.oam.SinkPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleSink = new Sink("exampleSink");
 *         var exampleSinkPolicy = new SinkPolicy("exampleSinkPolicy", SinkPolicyArgs.builder()
 *             .sinkIdentifier(exampleSink.id())
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", jsonArray(
 *                             "oam:CreateLink",
 *                             "oam:UpdateLink"
 *                         )),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Resource", "*"),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("AWS", jsonArray(
 *                                 "1111111111111",
 *                                 "222222222222"
 *                             ))
 *                         )),
 *                         jsonProperty("Condition", jsonObject(
 *                             jsonProperty("ForAllValues:StringEquals", jsonObject(
 *                                 jsonProperty("oam:ResourceTypes", jsonArray(
 *                                     "AWS::CloudWatch::Metric",
 *                                     "AWS::Logs::LogGroup"
 *                                 ))
 *                             ))
 *                         ))
 *                     )))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CloudWatch Observability Access Manager Sink Policy using the `sink_identifier`. For example:
 * ```sh
 *  $ pulumi import aws:oam/sinkPolicy:SinkPolicy example arn:aws:oam:us-west-2:123456789012:sink/sink-id
 * ```
 * @property policy JSON policy to use. If you are updating an existing policy, the entire existing policy is replaced by what you specify here.
 * @property sinkIdentifier ARN of the sink to attach this policy to.
 */
public data class SinkPolicyArgs(
    public val policy: Output<String>? = null,
    public val sinkIdentifier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.oam.SinkPolicyArgs> {
    override fun toJava(): com.pulumi.aws.oam.SinkPolicyArgs =
        com.pulumi.aws.oam.SinkPolicyArgs.builder()
            .policy(policy?.applyValue({ args0 -> args0 }))
            .sinkIdentifier(sinkIdentifier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SinkPolicyArgs].
 */
@PulumiTagMarker
public class SinkPolicyArgsBuilder internal constructor() {
    private var policy: Output<String>? = null

    private var sinkIdentifier: Output<String>? = null

    /**
     * @param value JSON policy to use. If you are updating an existing policy, the entire existing policy is replaced by what you specify here.
     */
    @JvmName("ttkpjyocvvkobuld")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value ARN of the sink to attach this policy to.
     */
    @JvmName("qarymnrkcxxbiqaq")
    public suspend fun sinkIdentifier(`value`: Output<String>) {
        this.sinkIdentifier = value
    }

    /**
     * @param value JSON policy to use. If you are updating an existing policy, the entire existing policy is replaced by what you specify here.
     */
    @JvmName("fkqybcrowesvoghb")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value ARN of the sink to attach this policy to.
     */
    @JvmName("cyisrmjxsddiutdo")
    public suspend fun sinkIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sinkIdentifier = mapped
    }

    internal fun build(): SinkPolicyArgs = SinkPolicyArgs(
        policy = policy,
        sinkIdentifier = sinkIdentifier,
    )
}
