@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.oam.kotlin.inputs

import com.pulumi.aws.oam.inputs.GetLinkPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getLink.
 * @property linkIdentifier ARN of the link.
 * @property tags
 */
public data class GetLinkPlainArgs(
    public val linkIdentifier: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.oam.inputs.GetLinkPlainArgs> {
    override fun toJava(): com.pulumi.aws.oam.inputs.GetLinkPlainArgs =
        com.pulumi.aws.oam.inputs.GetLinkPlainArgs.builder()
            .linkIdentifier(linkIdentifier.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetLinkPlainArgs].
 */
@PulumiTagMarker
public class GetLinkPlainArgsBuilder internal constructor() {
    private var linkIdentifier: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value ARN of the link.
     */
    @JvmName("cratnbxqfhfwuldi")
    public suspend fun linkIdentifier(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.linkIdentifier = mapped
    }

    /**
     * @param value
     */
    @JvmName("tyocfmetmljvwlhd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("xsrrvsbyubmcaqum")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetLinkPlainArgs = GetLinkPlainArgs(
        linkIdentifier = linkIdentifier ?: throw PulumiNullFieldException("linkIdentifier"),
        tags = tags,
    )
}
