@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.oam.kotlin.inputs

import com.pulumi.aws.oam.inputs.GetSinkPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSink.
 * @property sinkIdentifier ARN of the sink.
 * @property tags Tags assigned to the sink.
 */
public data class GetSinkPlainArgs(
    public val sinkIdentifier: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.oam.inputs.GetSinkPlainArgs> {
    override fun toJava(): com.pulumi.aws.oam.inputs.GetSinkPlainArgs =
        com.pulumi.aws.oam.inputs.GetSinkPlainArgs.builder()
            .sinkIdentifier(sinkIdentifier.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetSinkPlainArgs].
 */
@PulumiTagMarker
public class GetSinkPlainArgsBuilder internal constructor() {
    private var sinkIdentifier: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value ARN of the sink.
     */
    @JvmName("uarifclkxrjswxgt")
    public suspend fun sinkIdentifier(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sinkIdentifier = mapped
    }

    /**
     * @param value Tags assigned to the sink.
     */
    @JvmName("wlgfhjaqtyvprypg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Tags assigned to the sink.
     */
    @JvmName("dhnepaqtvnuwrxmg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetSinkPlainArgs = GetSinkPlainArgs(
        sinkIdentifier = sinkIdentifier ?: throw PulumiNullFieldException("sinkIdentifier"),
        tags = tags,
    )
}
