@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.oam.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getSink.
 * @property arn ARN of the sink.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name Name of the sink.
 * @property sinkId Random ID string that AWS generated as part of the sink ARN.
 * @property sinkIdentifier
 * @property tags Tags assigned to the sink.
 */
public data class GetSinkResult(
    public val arn: String,
    public val id: String,
    public val name: String,
    public val sinkId: String,
    public val sinkIdentifier: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.oam.outputs.GetSinkResult): GetSinkResult =
            GetSinkResult(
                arn = javaType.arn(),
                id = javaType.id(),
                name = javaType.name(),
                sinkId = javaType.sinkId(),
                sinkIdentifier = javaType.sinkIdentifier(),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            )
    }
}
