@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.oam.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getSinks.
 * @property arns Set of ARN of the Sinks.
 * @property id The provider-assigned unique ID for this managed resource.
 */
public data class GetSinksResult(
    public val arns: List<String>,
    public val id: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.oam.outputs.GetSinksResult): GetSinksResult =
            GetSinksResult(
                arns = javaType.arns().map({ args0 -> args0 }),
                id = javaType.id(),
            )
    }
}
