@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin

import com.pulumi.aws.opensearch.kotlin.outputs.DomainAdvancedSecurityOptions
import com.pulumi.aws.opensearch.kotlin.outputs.DomainAutoTuneOptions
import com.pulumi.aws.opensearch.kotlin.outputs.DomainClusterConfig
import com.pulumi.aws.opensearch.kotlin.outputs.DomainCognitoOptions
import com.pulumi.aws.opensearch.kotlin.outputs.DomainDomainEndpointOptions
import com.pulumi.aws.opensearch.kotlin.outputs.DomainEbsOptions
import com.pulumi.aws.opensearch.kotlin.outputs.DomainEncryptAtRest
import com.pulumi.aws.opensearch.kotlin.outputs.DomainLogPublishingOption
import com.pulumi.aws.opensearch.kotlin.outputs.DomainNodeToNodeEncryption
import com.pulumi.aws.opensearch.kotlin.outputs.DomainOffPeakWindowOptions
import com.pulumi.aws.opensearch.kotlin.outputs.DomainSnapshotOptions
import com.pulumi.aws.opensearch.kotlin.outputs.DomainSoftwareUpdateOptions
import com.pulumi.aws.opensearch.kotlin.outputs.DomainVpcOptions
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.opensearch.kotlin.outputs.DomainAdvancedSecurityOptions.Companion.toKotlin as domainAdvancedSecurityOptionsToKotlin
import com.pulumi.aws.opensearch.kotlin.outputs.DomainAutoTuneOptions.Companion.toKotlin as domainAutoTuneOptionsToKotlin
import com.pulumi.aws.opensearch.kotlin.outputs.DomainClusterConfig.Companion.toKotlin as domainClusterConfigToKotlin
import com.pulumi.aws.opensearch.kotlin.outputs.DomainCognitoOptions.Companion.toKotlin as domainCognitoOptionsToKotlin
import com.pulumi.aws.opensearch.kotlin.outputs.DomainDomainEndpointOptions.Companion.toKotlin as domainDomainEndpointOptionsToKotlin
import com.pulumi.aws.opensearch.kotlin.outputs.DomainEbsOptions.Companion.toKotlin as domainEbsOptionsToKotlin
import com.pulumi.aws.opensearch.kotlin.outputs.DomainEncryptAtRest.Companion.toKotlin as domainEncryptAtRestToKotlin
import com.pulumi.aws.opensearch.kotlin.outputs.DomainLogPublishingOption.Companion.toKotlin as domainLogPublishingOptionToKotlin
import com.pulumi.aws.opensearch.kotlin.outputs.DomainNodeToNodeEncryption.Companion.toKotlin as domainNodeToNodeEncryptionToKotlin
import com.pulumi.aws.opensearch.kotlin.outputs.DomainOffPeakWindowOptions.Companion.toKotlin as domainOffPeakWindowOptionsToKotlin
import com.pulumi.aws.opensearch.kotlin.outputs.DomainSnapshotOptions.Companion.toKotlin as domainSnapshotOptionsToKotlin
import com.pulumi.aws.opensearch.kotlin.outputs.DomainSoftwareUpdateOptions.Companion.toKotlin as domainSoftwareUpdateOptionsToKotlin
import com.pulumi.aws.opensearch.kotlin.outputs.DomainVpcOptions.Companion.toKotlin as domainVpcOptionsToKotlin

/**
 * Builder for [Domain].
 */
@PulumiTagMarker
public class DomainResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DomainArgs = DomainArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DomainArgsBuilder.() -> Unit) {
        val builder = DomainArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Domain {
        val builtJavaResource = com.pulumi.aws.opensearch.Domain(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Domain(builtJavaResource)
    }
}

/**
 * Manages an Amazon OpenSearch Domain.
 * ## Elasticsearch vs. OpenSearch
 * Amazon OpenSearch Service is the successor to Amazon Elasticsearch Service and supports OpenSearch and legacy Elasticsearch OSS (up to 7.10, the final open source version of the software).
 * OpenSearch Domain configurations are similar in many ways to Elasticsearch Domain configurations. However, there are important differences including these:
 * * OpenSearch has `engine_version` while Elasticsearch has `elasticsearch_version`
 * * Versions are specified differently - _e.g._, `Elasticsearch_7.10` with OpenSearch vs. `7.10` for Elasticsearch.
 * * `instance_type` argument values end in `search` for OpenSearch vs. `elasticsearch` for Elasticsearch (_e.g._, `t2.micro.search` vs. `t2.micro.elasticsearch`).
 * * The AWS-managed service-linked role for OpenSearch is called `AWSServiceRoleForAmazonOpenSearchService` instead of `AWSServiceRoleForAmazonElasticsearchService` for Elasticsearch.
 * There are also some potentially unexpected similarities in configurations:
 * * ARNs for both are prefaced with `arn:aws:es:`.
 * * Both OpenSearch and Elasticsearch use assume role policies that refer to the `Principal` `Service` as `es.amazonaws.com`.
 * * IAM policy actions, such as those you will find in `access_policies`, are prefaced with `es:` for both.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opensearch.Domain;
 * import com.pulumi.aws.opensearch.DomainArgs;
 * import com.pulumi.aws.opensearch.inputs.DomainClusterConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Domain("example", DomainArgs.builder()
 *             .clusterConfig(DomainClusterConfigArgs.builder()
 *                 .instanceType("r4.large.search")
 *                 .build())
 *             .engineVersion("Elasticsearch_7.10")
 *             .tags(Map.of("Domain", "TestDomain"))
 *             .build());
 *     }
 * }
 * ```
 * ### Access Policy
 * > See also: `aws.opensearch.DomainPolicy` resource
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.opensearch.Domain;
 * import com.pulumi.aws.opensearch.DomainArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var domain = config.get("domain").orElse("tf-test");
 *         final var currentRegion = AwsFunctions.getRegion();
 *         final var currentCallerIdentity = AwsFunctions.getCallerIdentity();
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("*")
 *                     .identifiers("*")
 *                     .build())
 *                 .actions("es:*")
 *                 .resources(String.format("arn:aws:es:%s:%s:domain/%s/*", currentRegion.applyValue(getRegionResult -> getRegionResult.name()),currentCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()),domain))
 *                 .conditions(GetPolicyDocumentStatementConditionArgs.builder()
 *                     .test("IpAddress")
 *                     .variable("aws:SourceIp")
 *                     .values("66.193.100.22/32")
 *                     .build())
 *                 .build())
 *             .build());
 *         var exampleDomain = new Domain("exampleDomain", DomainArgs.builder()
 *             .accessPolicies(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *     }
 * }
 * ```
 * ### Log publishing to CloudWatch Logs
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.LogGroup;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.cloudwatch.LogResourcePolicy;
 * import com.pulumi.aws.cloudwatch.LogResourcePolicyArgs;
 * import com.pulumi.aws.opensearch.Domain;
 * import com.pulumi.aws.opensearch.DomainArgs;
 * import com.pulumi.aws.opensearch.inputs.DomainLogPublishingOptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleLogGroup = new LogGroup("exampleLogGroup");
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("es.amazonaws.com")
 *                     .build())
 *                 .actions(
 *                     "logs:PutLogEvents",
 *                     "logs:PutLogEventsBatch",
 *                     "logs:CreateLogStream")
 *                 .resources("arn:aws:logs:*")
 *                 .build())
 *             .build());
 *         var exampleLogResourcePolicy = new LogResourcePolicy("exampleLogResourcePolicy", LogResourcePolicyArgs.builder()
 *             .policyName("example")
 *             .policyDocument(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var exampleDomain = new Domain("exampleDomain", DomainArgs.builder()
 *             .logPublishingOptions(DomainLogPublishingOptionArgs.builder()
 *                 .cloudwatchLogGroupArn(exampleLogGroup.arn())
 *                 .logType("INDEX_SLOW_LOGS")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### VPC based OpenSearch
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Ec2Functions;
 * import com.pulumi.aws.ec2.inputs.GetVpcArgs;
 * import com.pulumi.aws.ec2.inputs.GetSubnetsArgs;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.ec2.SecurityGroup;
 * import com.pulumi.aws.ec2.SecurityGroupArgs;
 * import com.pulumi.aws.ec2.inputs.SecurityGroupIngressArgs;
 * import com.pulumi.aws.iam.ServiceLinkedRole;
 * import com.pulumi.aws.iam.ServiceLinkedRoleArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.opensearch.Domain;
 * import com.pulumi.aws.opensearch.DomainArgs;
 * import com.pulumi.aws.opensearch.inputs.DomainClusterConfigArgs;
 * import com.pulumi.aws.opensearch.inputs.DomainVpcOptionsArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var vpc = config.get("vpc");
 *         final var domain = config.get("domain").orElse("tf-test");
 *         final var exampleVpc = Ec2Functions.getVpc(GetVpcArgs.builder()
 *             .tags(Map.of("Name", vpc))
 *             .build());
 *         final var exampleSubnets = Ec2Functions.getSubnets(GetSubnetsArgs.builder()
 *             .filters(GetSubnetsFilterArgs.builder()
 *                 .name("vpc-id")
 *                 .values(exampleVpc.applyValue(getVpcResult -> getVpcResult.id()))
 *                 .build())
 *             .tags(Map.of("Tier", "private"))
 *             .build());
 *         final var currentRegion = AwsFunctions.getRegion();
 *         final var currentCallerIdentity = AwsFunctions.getCallerIdentity();
 *         var exampleSecurityGroup = new SecurityGroup("exampleSecurityGroup", SecurityGroupArgs.builder()
 *             .description("Managed by Pulumi")
 *             .vpcId(exampleVpc.applyValue(getVpcResult -> getVpcResult.id()))
 *             .ingress(SecurityGroupIngressArgs.builder()
 *                 .fromPort(443)
 *                 .toPort(443)
 *                 .protocol("tcp")
 *                 .cidrBlocks(exampleVpc.applyValue(getVpcResult -> getVpcResult.cidrBlock()))
 *                 .build())
 *             .build());
 *         var exampleServiceLinkedRole = new ServiceLinkedRole("exampleServiceLinkedRole", ServiceLinkedRoleArgs.builder()
 *             .awsServiceName("opensearchservice.amazonaws.com")
 *             .build());
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("*")
 *                     .identifiers("*")
 *                     .build())
 *                 .actions("es:*")
 *                 .resources(String.format("arn:aws:es:%s:%s:domain/%s/*", currentRegion.applyValue(getRegionResult -> getRegionResult.name()),currentCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()),domain))
 *                 .build())
 *             .build());
 *         var exampleDomain = new Domain("exampleDomain", DomainArgs.builder()
 *             .engineVersion("OpenSearch_1.0")
 *             .clusterConfig(DomainClusterConfigArgs.builder()
 *                 .instanceType("m4.large.search")
 *                 .zoneAwarenessEnabled(true)
 *                 .build())
 *             .vpcOptions(DomainVpcOptionsArgs.builder()
 *                 .subnetIds(
 *                     exampleSubnets.applyValue(getSubnetsResult -> getSubnetsResult.ids()[0]),
 *                     exampleSubnets.applyValue(getSubnetsResult -> getSubnetsResult.ids()[1]))
 *                 .securityGroupIds(exampleSecurityGroup.id())
 *                 .build())
 *             .advancedOptions(Map.of("rest.action.multi.allow_explicit_index", "true"))
 *             .accessPolicies(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .tags(Map.of("Domain", "TestDomain"))
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleServiceLinkedRole)
 *                 .build());
 *     }
 * }
 * ```
 * ### First apply
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opensearch.Domain;
 * import com.pulumi.aws.opensearch.DomainArgs;
 * import com.pulumi.aws.opensearch.inputs.DomainAdvancedSecurityOptionsArgs;
 * import com.pulumi.aws.opensearch.inputs.DomainAdvancedSecurityOptionsMasterUserOptionsArgs;
 * import com.pulumi.aws.opensearch.inputs.DomainClusterConfigArgs;
 * import com.pulumi.aws.opensearch.inputs.DomainDomainEndpointOptionsArgs;
 * import com.pulumi.aws.opensearch.inputs.DomainEbsOptionsArgs;
 * import com.pulumi.aws.opensearch.inputs.DomainEncryptAtRestArgs;
 * import com.pulumi.aws.opensearch.inputs.DomainNodeToNodeEncryptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Domain("example", DomainArgs.builder()
 *             .advancedSecurityOptions(DomainAdvancedSecurityOptionsArgs.builder()
 *                 .anonymousAuthEnabled(true)
 *                 .enabled(false)
 *                 .internalUserDatabaseEnabled(true)
 *                 .masterUserOptions(DomainAdvancedSecurityOptionsMasterUserOptionsArgs.builder()
 *                     .masterUserName("example")
 *                     .masterUserPassword("Barbarbarbar1!")
 *                     .build())
 *                 .build())
 *             .clusterConfig(DomainClusterConfigArgs.builder()
 *                 .instanceType("r5.large.search")
 *                 .build())
 *             .domainEndpointOptions(DomainDomainEndpointOptionsArgs.builder()
 *                 .enforceHttps(true)
 *                 .tlsSecurityPolicy("Policy-Min-TLS-1-2-2019-07")
 *                 .build())
 *             .ebsOptions(DomainEbsOptionsArgs.builder()
 *                 .ebsEnabled(true)
 *                 .volumeSize(10)
 *                 .build())
 *             .encryptAtRest(DomainEncryptAtRestArgs.builder()
 *                 .enabled(true)
 *                 .build())
 *             .engineVersion("Elasticsearch_7.1")
 *             .nodeToNodeEncryption(DomainNodeToNodeEncryptionArgs.builder()
 *                 .enabled(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Second apply
 * Notice that the only change is `advanced_security_options.0.enabled` is now set to `true`.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opensearch.Domain;
 * import com.pulumi.aws.opensearch.DomainArgs;
 * import com.pulumi.aws.opensearch.inputs.DomainAdvancedSecurityOptionsArgs;
 * import com.pulumi.aws.opensearch.inputs.DomainAdvancedSecurityOptionsMasterUserOptionsArgs;
 * import com.pulumi.aws.opensearch.inputs.DomainClusterConfigArgs;
 * import com.pulumi.aws.opensearch.inputs.DomainDomainEndpointOptionsArgs;
 * import com.pulumi.aws.opensearch.inputs.DomainEbsOptionsArgs;
 * import com.pulumi.aws.opensearch.inputs.DomainEncryptAtRestArgs;
 * import com.pulumi.aws.opensearch.inputs.DomainNodeToNodeEncryptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Domain("example", DomainArgs.builder()
 *             .advancedSecurityOptions(DomainAdvancedSecurityOptionsArgs.builder()
 *                 .anonymousAuthEnabled(true)
 *                 .enabled(true)
 *                 .internalUserDatabaseEnabled(true)
 *                 .masterUserOptions(DomainAdvancedSecurityOptionsMasterUserOptionsArgs.builder()
 *                     .masterUserName("example")
 *                     .masterUserPassword("Barbarbarbar1!")
 *                     .build())
 *                 .build())
 *             .clusterConfig(DomainClusterConfigArgs.builder()
 *                 .instanceType("r5.large.search")
 *                 .build())
 *             .domainEndpointOptions(DomainDomainEndpointOptionsArgs.builder()
 *                 .enforceHttps(true)
 *                 .tlsSecurityPolicy("Policy-Min-TLS-1-2-2019-07")
 *                 .build())
 *             .ebsOptions(DomainEbsOptionsArgs.builder()
 *                 .ebsEnabled(true)
 *                 .volumeSize(10)
 *                 .build())
 *             .encryptAtRest(DomainEncryptAtRestArgs.builder()
 *                 .enabled(true)
 *                 .build())
 *             .engineVersion("Elasticsearch_7.1")
 *             .nodeToNodeEncryption(DomainNodeToNodeEncryptionArgs.builder()
 *                 .enabled(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import OpenSearch domains using the `domain_name`. For example:
 * ```sh
 *  $ pulumi import aws:opensearch/domain:Domain example domain_name
 * ```
 * */*/
 */
public class Domain internal constructor(
    override val javaResource: com.pulumi.aws.opensearch.Domain,
) : KotlinCustomResource(javaResource, DomainMapper) {
    /**
     * IAM policy document specifying the access policies for the domain.
     */
    public val accessPolicies: Output<String>
        get() = javaResource.accessPolicies().applyValue({ args0 -> args0 })

    /**
     * Key-value string pairs to specify advanced configuration options. Note that the values for these configuration options must be strings (wrapped in quotes) or they may be wrong and cause a perpetual diff, causing the provider to want to recreate your OpenSearch domain on every apply.
     */
    public val advancedOptions: Output<Map<String, String>>
        get() = javaResource.advancedOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Configuration block for [fine-grained access control](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html). Detailed below.
     */
    public val advancedSecurityOptions: Output<DomainAdvancedSecurityOptions>
        get() = javaResource.advancedSecurityOptions().applyValue({ args0 ->
            args0.let({ args0 ->
                domainAdvancedSecurityOptionsToKotlin(args0)
            })
        })

    /**
     * ARN of the domain.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Configuration block for the Auto-Tune options of the domain. Detailed below.
     */
    public val autoTuneOptions: Output<DomainAutoTuneOptions>
        get() = javaResource.autoTuneOptions().applyValue({ args0 ->
            args0.let({ args0 ->
                domainAutoTuneOptionsToKotlin(args0)
            })
        })

    /**
     * Configuration block for the cluster of the domain. Detailed below.
     */
    public val clusterConfig: Output<DomainClusterConfig>
        get() = javaResource.clusterConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                domainClusterConfigToKotlin(args0)
            })
        })

    /**
     * Configuration block for authenticating dashboard with Cognito. Detailed below.
     */
    public val cognitoOptions: Output<DomainCognitoOptions>?
        get() = javaResource.cognitoOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> domainCognitoOptionsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Domain-specific endpoint for Dashboard without https scheme.
     */
    public val dashboardEndpoint: Output<String>
        get() = javaResource.dashboardEndpoint().applyValue({ args0 -> args0 })

    /**
     * Configuration block for domain endpoint HTTP(S) related options. Detailed below.
     */
    public val domainEndpointOptions: Output<DomainDomainEndpointOptions>
        get() = javaResource.domainEndpointOptions().applyValue({ args0 ->
            args0.let({ args0 ->
                domainDomainEndpointOptionsToKotlin(args0)
            })
        })

    /**
     * Unique identifier for the domain.
     */
    public val domainId: Output<String>
        get() = javaResource.domainId().applyValue({ args0 -> args0 })

    /**
     * Name of the domain.
     * The following arguments are optional:
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })

    /**
     * Configuration block for EBS related options, may be required based on chosen [instance size](https://aws.amazon.com/opensearch-service/pricing/). Detailed below.
     */
    public val ebsOptions: Output<DomainEbsOptions>
        get() = javaResource.ebsOptions().applyValue({ args0 ->
            args0.let({ args0 ->
                domainEbsOptionsToKotlin(args0)
            })
        })

    /**
     * Configuration block for encrypt at rest options. Only available for [certain instance types](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/encryption-at-rest.html). Detailed below.
     */
    public val encryptAtRest: Output<DomainEncryptAtRest>
        get() = javaResource.encryptAtRest().applyValue({ args0 ->
            args0.let({ args0 ->
                domainEncryptAtRestToKotlin(args0)
            })
        })

    /**
     * Domain-specific endpoint used to submit index, search, and data upload requests.
     */
    public val endpoint: Output<String>
        get() = javaResource.endpoint().applyValue({ args0 -> args0 })

    /**
     * Either `Elasticsearch_X.Y` or `OpenSearch_X.Y` to specify the engine version for the Amazon OpenSearch Service domain. For example, `OpenSearch_1.0` or `Elasticsearch_7.9`.
     * See [Creating and managing Amazon OpenSearch Service domains](http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomains).
     * Defaults to the lastest version of OpenSearch.
     */
    public val engineVersion: Output<String>
        get() = javaResource.engineVersion().applyValue({ args0 -> args0 })

    /**
     * (**Deprecated**) Domain-specific endpoint for kibana without https scheme. Use the `dashboard_endpoint` attribute instead.
     */
    @Deprecated(
        message = """
  use 'dashboard_endpoint' attribute instead
  """,
    )
    public val kibanaEndpoint: Output<String>
        get() = javaResource.kibanaEndpoint().applyValue({ args0 -> args0 })

    /**
     * Configuration block for publishing slow and application logs to CloudWatch Logs. This block can be declared multiple times, for each log_type, within the same resource. Detailed below.
     */
    public val logPublishingOptions: Output<List<DomainLogPublishingOption>>?
        get() = javaResource.logPublishingOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        domainLogPublishingOptionToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Configuration block for node-to-node encryption options. Detailed below.
     */
    public val nodeToNodeEncryption: Output<DomainNodeToNodeEncryption>
        get() = javaResource.nodeToNodeEncryption().applyValue({ args0 ->
            args0.let({ args0 ->
                domainNodeToNodeEncryptionToKotlin(args0)
            })
        })

    /**
     * Configuration to add Off Peak update options. ([documentation](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/off-peak.html)). Detailed below.
     */
    public val offPeakWindowOptions: Output<DomainOffPeakWindowOptions>
        get() = javaResource.offPeakWindowOptions().applyValue({ args0 ->
            args0.let({ args0 ->
                domainOffPeakWindowOptionsToKotlin(args0)
            })
        })

    /**
     * Configuration block for snapshot related options. Detailed below. DEPRECATED. For domains running OpenSearch 5.3 and later, Amazon OpenSearch takes hourly automated snapshots, making this setting irrelevant. For domains running earlier versions, OpenSearch takes daily automated snapshots.
     */
    public val snapshotOptions: Output<DomainSnapshotOptions>?
        get() = javaResource.snapshotOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> domainSnapshotOptionsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Software update options for the domain. Detailed below.
     */
    public val softwareUpdateOptions: Output<DomainSoftwareUpdateOptions>
        get() = javaResource.softwareUpdateOptions().applyValue({ args0 ->
            args0.let({ args0 ->
                domainSoftwareUpdateOptionsToKotlin(args0)
            })
        })

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * * `vpc_options.0.availability_zones` - If the domain was created inside a VPC, the names of the availability zones the configured `subnet_ids` were created inside.
     * * `vpc_options.0.vpc_id` - If the domain was created inside a VPC, the ID of the VPC.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Configuration block for VPC related options. Adding or removing this configuration forces a new resource ([documentation](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html)). Detailed below.
     */
    public val vpcOptions: Output<DomainVpcOptions>?
        get() = javaResource.vpcOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    domainVpcOptionsToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object DomainMapper : ResourceMapper<Domain> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.opensearch.Domain::class == javaResource::class

    override fun map(javaResource: Resource): Domain = Domain(
        javaResource as
            com.pulumi.aws.opensearch.Domain,
    )
}

/**
 * @see [Domain].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Domain].
 */
public suspend fun domain(name: String, block: suspend DomainResourceBuilder.() -> Unit): Domain {
    val builder = DomainResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Domain].
 * @param name The _unique_ name of the resulting resource.
 */
public fun domain(name: String): Domain {
    val builder = DomainResourceBuilder()
    builder.name(name)
    return builder.build()
}
