@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DomainPolicy].
 */
@PulumiTagMarker
public class DomainPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DomainPolicyArgs = DomainPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DomainPolicyArgsBuilder.() -> Unit) {
        val builder = DomainPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DomainPolicy {
        val builtJavaResource = com.pulumi.aws.opensearch.DomainPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DomainPolicy(builtJavaResource)
    }
}

/**
 * Allows setting policy to an OpenSearch domain while referencing domain attributes (e.g., ARN).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opensearch.Domain;
 * import com.pulumi.aws.opensearch.DomainArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.opensearch.DomainPolicy;
 * import com.pulumi.aws.opensearch.DomainPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Domain("example", DomainArgs.builder()
 *             .engineVersion("OpenSearch_1.1")
 *             .build());
 *         final var mainPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("*")
 *                     .identifiers("*")
 *                     .build())
 *                 .actions("es:*")
 *                 .resources(example.arn().applyValue(arn -> String.format("%s/*", arn)))
 *                 .conditions(GetPolicyDocumentStatementConditionArgs.builder()
 *                     .test("IpAddress")
 *                     .variable("aws:SourceIp")
 *                     .values("127.0.0.1/32")
 *                     .build())
 *                 .build())
 *             .build());
 *         var mainDomainPolicy = new DomainPolicy("mainDomainPolicy", DomainPolicyArgs.builder()
 *             .domainName(example.domainName())
 *             .accessPolicies(mainPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(mainPolicyDocument -> mainPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * */
 */
public class DomainPolicy internal constructor(
    override val javaResource: com.pulumi.aws.opensearch.DomainPolicy,
) : KotlinCustomResource(javaResource, DomainPolicyMapper) {
    /**
     * IAM policy document specifying the access policies for the domain
     */
    public val accessPolicies: Output<String>
        get() = javaResource.accessPolicies().applyValue({ args0 -> args0 })

    /**
     * Name of the domain.
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })
}

public object DomainPolicyMapper : ResourceMapper<DomainPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.opensearch.DomainPolicy::class == javaResource::class

    override fun map(javaResource: Resource): DomainPolicy = DomainPolicy(
        javaResource as
            com.pulumi.aws.opensearch.DomainPolicy,
    )
}

/**
 * @see [DomainPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DomainPolicy].
 */
public suspend fun domainPolicy(
    name: String,
    block: suspend DomainPolicyResourceBuilder.() -> Unit,
): DomainPolicy {
    val builder = DomainPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DomainPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun domainPolicy(name: String): DomainPolicy {
    val builder = DomainPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
