@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin

import com.pulumi.aws.opensearch.DomainPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Allows setting policy to an OpenSearch domain while referencing domain attributes (e.g., ARN).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opensearch.Domain;
 * import com.pulumi.aws.opensearch.DomainArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.opensearch.DomainPolicy;
 * import com.pulumi.aws.opensearch.DomainPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Domain("example", DomainArgs.builder()
 *             .engineVersion("OpenSearch_1.1")
 *             .build());
 *         final var mainPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("*")
 *                     .identifiers("*")
 *                     .build())
 *                 .actions("es:*")
 *                 .resources(example.arn().applyValue(arn -> String.format("%s/*", arn)))
 *                 .conditions(GetPolicyDocumentStatementConditionArgs.builder()
 *                     .test("IpAddress")
 *                     .variable("aws:SourceIp")
 *                     .values("127.0.0.1/32")
 *                     .build())
 *                 .build())
 *             .build());
 *         var mainDomainPolicy = new DomainPolicy("mainDomainPolicy", DomainPolicyArgs.builder()
 *             .domainName(example.domainName())
 *             .accessPolicies(mainPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(mainPolicyDocument -> mainPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * @property accessPolicies IAM policy document specifying the access policies for the domain
 * @property domainName Name of the domain.
 * */
 */
public data class DomainPolicyArgs(
    public val accessPolicies: Output<String>? = null,
    public val domainName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.opensearch.DomainPolicyArgs> {
    override fun toJava(): com.pulumi.aws.opensearch.DomainPolicyArgs =
        com.pulumi.aws.opensearch.DomainPolicyArgs.builder()
            .accessPolicies(accessPolicies?.applyValue({ args0 -> args0 }))
            .domainName(domainName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainPolicyArgs].
 */
@PulumiTagMarker
public class DomainPolicyArgsBuilder internal constructor() {
    private var accessPolicies: Output<String>? = null

    private var domainName: Output<String>? = null

    /**
     * @param value IAM policy document specifying the access policies for the domain
     */
    @JvmName("yqwwebfiaanrodyw")
    public suspend fun accessPolicies(`value`: Output<String>) {
        this.accessPolicies = value
    }

    /**
     * @param value Name of the domain.
     */
    @JvmName("ngbidprkjbcdjqoq")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value IAM policy document specifying the access policies for the domain
     */
    @JvmName("sseomdqvibbbcwll")
    public suspend fun accessPolicies(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessPolicies = mapped
    }

    /**
     * @param value Name of the domain.
     */
    @JvmName("almppltlkbltvnhb")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    internal fun build(): DomainPolicyArgs = DomainPolicyArgs(
        accessPolicies = accessPolicies,
        domainName = domainName,
    )
}
