@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin

import com.pulumi.aws.opensearch.kotlin.outputs.DomainSamlOptionsSamlOptions
import com.pulumi.aws.opensearch.kotlin.outputs.DomainSamlOptionsSamlOptions.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DomainSamlOptions].
 */
@PulumiTagMarker
public class DomainSamlOptionsResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DomainSamlOptionsArgs = DomainSamlOptionsArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DomainSamlOptionsArgsBuilder.() -> Unit) {
        val builder = DomainSamlOptionsArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DomainSamlOptions {
        val builtJavaResource = com.pulumi.aws.opensearch.DomainSamlOptions(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DomainSamlOptions(builtJavaResource)
    }
}

/**
 * Manages SAML authentication options for an AWS OpenSearch Domain.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opensearch.Domain;
 * import com.pulumi.aws.opensearch.DomainArgs;
 * import com.pulumi.aws.opensearch.inputs.DomainClusterConfigArgs;
 * import com.pulumi.aws.opensearch.inputs.DomainSnapshotOptionsArgs;
 * import com.pulumi.aws.opensearch.DomainSamlOptions;
 * import com.pulumi.aws.opensearch.DomainSamlOptionsArgs;
 * import com.pulumi.aws.opensearch.inputs.DomainSamlOptionsSamlOptionsArgs;
 * import com.pulumi.aws.opensearch.inputs.DomainSamlOptionsSamlOptionsIdpArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleDomain = new Domain("exampleDomain", DomainArgs.builder()
 *             .engineVersion("OpenSearch_1.1")
 *             .clusterConfig(DomainClusterConfigArgs.builder()
 *                 .instanceType("r4.large.search")
 *                 .build())
 *             .snapshotOptions(DomainSnapshotOptionsArgs.builder()
 *                 .automatedSnapshotStartHour(23)
 *                 .build())
 *             .tags(Map.of("Domain", "TestDomain"))
 *             .build());
 *         var exampleDomainSamlOptions = new DomainSamlOptions("exampleDomainSamlOptions", DomainSamlOptionsArgs.builder()
 *             .domainName(exampleDomain.domainName())
 *             .samlOptions(DomainSamlOptionsSamlOptionsArgs.builder()
 *                 .enabled(true)
 *                 .idp(DomainSamlOptionsSamlOptionsIdpArgs.builder()
 *                     .entityId("https://example.com")
 *                     .metadataContent(Files.readString(Paths.get("./saml-metadata.xml")))
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import OpenSearch domains using the `domain_name`. For example:
 * ```sh
 *  $ pulumi import aws:opensearch/domainSamlOptions:DomainSamlOptions example domain_name
 * ```
 *
 */
public class DomainSamlOptions internal constructor(
    override val javaResource: com.pulumi.aws.opensearch.DomainSamlOptions,
) : KotlinCustomResource(javaResource, DomainSamlOptionsMapper) {
    /**
     * Name of the domain.
     * The following arguments are optional:
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })

    /**
     * SAML authentication options for an AWS OpenSearch Domain.
     */
    public val samlOptions: Output<DomainSamlOptionsSamlOptions>?
        get() = javaResource.samlOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })
}

public object DomainSamlOptionsMapper : ResourceMapper<DomainSamlOptions> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.opensearch.DomainSamlOptions::class == javaResource::class

    override fun map(javaResource: Resource): DomainSamlOptions = DomainSamlOptions(
        javaResource as
            com.pulumi.aws.opensearch.DomainSamlOptions,
    )
}

/**
 * @see [DomainSamlOptions].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DomainSamlOptions].
 */
public suspend fun domainSamlOptions(
    name: String,
    block: suspend DomainSamlOptionsResourceBuilder.() -> Unit,
): DomainSamlOptions {
    val builder = DomainSamlOptionsResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DomainSamlOptions].
 * @param name The _unique_ name of the resulting resource.
 */
public fun domainSamlOptions(name: String): DomainSamlOptions {
    val builder = DomainSamlOptionsResourceBuilder()
    builder.name(name)
    return builder.build()
}
