@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin

import com.pulumi.aws.opensearch.DomainSamlOptionsArgs.builder
import com.pulumi.aws.opensearch.kotlin.inputs.DomainSamlOptionsSamlOptionsArgs
import com.pulumi.aws.opensearch.kotlin.inputs.DomainSamlOptionsSamlOptionsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Manages SAML authentication options for an AWS OpenSearch Domain.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opensearch.Domain;
 * import com.pulumi.aws.opensearch.DomainArgs;
 * import com.pulumi.aws.opensearch.inputs.DomainClusterConfigArgs;
 * import com.pulumi.aws.opensearch.inputs.DomainSnapshotOptionsArgs;
 * import com.pulumi.aws.opensearch.DomainSamlOptions;
 * import com.pulumi.aws.opensearch.DomainSamlOptionsArgs;
 * import com.pulumi.aws.opensearch.inputs.DomainSamlOptionsSamlOptionsArgs;
 * import com.pulumi.aws.opensearch.inputs.DomainSamlOptionsSamlOptionsIdpArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleDomain = new Domain("exampleDomain", DomainArgs.builder()
 *             .engineVersion("OpenSearch_1.1")
 *             .clusterConfig(DomainClusterConfigArgs.builder()
 *                 .instanceType("r4.large.search")
 *                 .build())
 *             .snapshotOptions(DomainSnapshotOptionsArgs.builder()
 *                 .automatedSnapshotStartHour(23)
 *                 .build())
 *             .tags(Map.of("Domain", "TestDomain"))
 *             .build());
 *         var exampleDomainSamlOptions = new DomainSamlOptions("exampleDomainSamlOptions", DomainSamlOptionsArgs.builder()
 *             .domainName(exampleDomain.domainName())
 *             .samlOptions(DomainSamlOptionsSamlOptionsArgs.builder()
 *                 .enabled(true)
 *                 .idp(DomainSamlOptionsSamlOptionsIdpArgs.builder()
 *                     .entityId("https://example.com")
 *                     .metadataContent(Files.readString(Paths.get("./saml-metadata.xml")))
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import OpenSearch domains using the `domain_name`. For example:
 * ```sh
 *  $ pulumi import aws:opensearch/domainSamlOptions:DomainSamlOptions example domain_name
 * ```
 * @property domainName Name of the domain.
 * The following arguments are optional:
 * @property samlOptions SAML authentication options for an AWS OpenSearch Domain.
 */
public data class DomainSamlOptionsArgs(
    public val domainName: Output<String>? = null,
    public val samlOptions: Output<DomainSamlOptionsSamlOptionsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.opensearch.DomainSamlOptionsArgs> {
    override fun toJava(): com.pulumi.aws.opensearch.DomainSamlOptionsArgs =
        com.pulumi.aws.opensearch.DomainSamlOptionsArgs.builder()
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .samlOptions(samlOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DomainSamlOptionsArgs].
 */
@PulumiTagMarker
public class DomainSamlOptionsArgsBuilder internal constructor() {
    private var domainName: Output<String>? = null

    private var samlOptions: Output<DomainSamlOptionsSamlOptionsArgs>? = null

    /**
     * @param value Name of the domain.
     * The following arguments are optional:
     */
    @JvmName("jawkrmwqjtylcyid")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value SAML authentication options for an AWS OpenSearch Domain.
     */
    @JvmName("lywxmavlkunygmao")
    public suspend fun samlOptions(`value`: Output<DomainSamlOptionsSamlOptionsArgs>) {
        this.samlOptions = value
    }

    /**
     * @param value Name of the domain.
     * The following arguments are optional:
     */
    @JvmName("jskpdhnsgbpujncb")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value SAML authentication options for an AWS OpenSearch Domain.
     */
    @JvmName("xlorupjjnvanacxt")
    public suspend fun samlOptions(`value`: DomainSamlOptionsSamlOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.samlOptions = mapped
    }

    /**
     * @param argument SAML authentication options for an AWS OpenSearch Domain.
     */
    @JvmName("yuuglwcwmuobhwft")
    public suspend
    fun samlOptions(argument: suspend DomainSamlOptionsSamlOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = DomainSamlOptionsSamlOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.samlOptions = mapped
    }

    internal fun build(): DomainSamlOptionsArgs = DomainSamlOptionsArgs(
        domainName = domainName,
        samlOptions = samlOptions,
    )
}
