@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [InboundConnectionAccepter].
 */
@PulumiTagMarker
public class InboundConnectionAccepterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InboundConnectionAccepterArgs = InboundConnectionAccepterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InboundConnectionAccepterArgsBuilder.() -> Unit) {
        val builder = InboundConnectionAccepterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): InboundConnectionAccepter {
        val builtJavaResource =
            com.pulumi.aws.opensearch.InboundConnectionAccepter(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return InboundConnectionAccepter(builtJavaResource)
    }
}

/**
 * Manages an [AWS Opensearch Inbound Connection Accepter](https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_AcceptInboundConnection.html). If connecting domains from different AWS accounts, ensure that the accepter is configured to use the AWS account where the _remote_ opensearch domain exists.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.opensearch.OutboundConnection;
 * import com.pulumi.aws.opensearch.OutboundConnectionArgs;
 * import com.pulumi.aws.opensearch.inputs.OutboundConnectionLocalDomainInfoArgs;
 * import com.pulumi.aws.opensearch.inputs.OutboundConnectionRemoteDomainInfoArgs;
 * import com.pulumi.aws.opensearch.InboundConnectionAccepter;
 * import com.pulumi.aws.opensearch.InboundConnectionAccepterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var currentCallerIdentity = AwsFunctions.getCallerIdentity();
 *         final var currentRegion = AwsFunctions.getRegion();
 *         var fooOutboundConnection = new OutboundConnection("fooOutboundConnection", OutboundConnectionArgs.builder()
 *             .connectionAlias("outbound_connection")
 *             .localDomainInfo(OutboundConnectionLocalDomainInfoArgs.builder()
 *                 .ownerId(currentCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))
 *                 .region(currentRegion.applyValue(getRegionResult -> getRegionResult.name()))
 *                 .domainName(aws_opensearch_domain.local_domain().domain_name())
 *                 .build())
 *             .remoteDomainInfo(OutboundConnectionRemoteDomainInfoArgs.builder()
 *                 .ownerId(currentCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))
 *                 .region(currentRegion.applyValue(getRegionResult -> getRegionResult.name()))
 *                 .domainName(aws_opensearch_domain.remote_domain().domain_name())
 *                 .build())
 *             .build());
 *         var fooInboundConnectionAccepter = new InboundConnectionAccepter("fooInboundConnectionAccepter", InboundConnectionAccepterArgs.builder()
 *             .connectionId(fooOutboundConnection.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import AWS Opensearch Inbound Connection Accepters using the Inbound Connection ID. For example:
 * ```sh
 *  $ pulumi import aws:opensearch/inboundConnectionAccepter:InboundConnectionAccepter foo connection-id
 * ```
 *
 */
public class InboundConnectionAccepter internal constructor(
    override val javaResource: com.pulumi.aws.opensearch.InboundConnectionAccepter,
) : KotlinCustomResource(javaResource, InboundConnectionAccepterMapper) {
    /**
     * Specifies the ID of the connection to accept.
     */
    public val connectionId: Output<String>
        get() = javaResource.connectionId().applyValue({ args0 -> args0 })

    /**
     * Status of the connection request.
     */
    public val connectionStatus: Output<String>
        get() = javaResource.connectionStatus().applyValue({ args0 -> args0 })
}

public object InboundConnectionAccepterMapper : ResourceMapper<InboundConnectionAccepter> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.opensearch.InboundConnectionAccepter::class == javaResource::class

    override fun map(javaResource: Resource): InboundConnectionAccepter =
        InboundConnectionAccepter(javaResource as com.pulumi.aws.opensearch.InboundConnectionAccepter)
}

/**
 * @see [InboundConnectionAccepter].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [InboundConnectionAccepter].
 */
public suspend fun inboundConnectionAccepter(
    name: String,
    block: suspend InboundConnectionAccepterResourceBuilder.() -> Unit,
): InboundConnectionAccepter {
    val builder = InboundConnectionAccepterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [InboundConnectionAccepter].
 * @param name The _unique_ name of the resulting resource.
 */
public fun inboundConnectionAccepter(name: String): InboundConnectionAccepter {
    val builder = InboundConnectionAccepterResourceBuilder()
    builder.name(name)
    return builder.build()
}
