@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin

import com.pulumi.aws.opensearch.InboundConnectionAccepterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages an [AWS Opensearch Inbound Connection Accepter](https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_AcceptInboundConnection.html). If connecting domains from different AWS accounts, ensure that the accepter is configured to use the AWS account where the _remote_ opensearch domain exists.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.opensearch.OutboundConnection;
 * import com.pulumi.aws.opensearch.OutboundConnectionArgs;
 * import com.pulumi.aws.opensearch.inputs.OutboundConnectionLocalDomainInfoArgs;
 * import com.pulumi.aws.opensearch.inputs.OutboundConnectionRemoteDomainInfoArgs;
 * import com.pulumi.aws.opensearch.InboundConnectionAccepter;
 * import com.pulumi.aws.opensearch.InboundConnectionAccepterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var currentCallerIdentity = AwsFunctions.getCallerIdentity();
 *         final var currentRegion = AwsFunctions.getRegion();
 *         var fooOutboundConnection = new OutboundConnection("fooOutboundConnection", OutboundConnectionArgs.builder()
 *             .connectionAlias("outbound_connection")
 *             .localDomainInfo(OutboundConnectionLocalDomainInfoArgs.builder()
 *                 .ownerId(currentCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))
 *                 .region(currentRegion.applyValue(getRegionResult -> getRegionResult.name()))
 *                 .domainName(aws_opensearch_domain.local_domain().domain_name())
 *                 .build())
 *             .remoteDomainInfo(OutboundConnectionRemoteDomainInfoArgs.builder()
 *                 .ownerId(currentCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))
 *                 .region(currentRegion.applyValue(getRegionResult -> getRegionResult.name()))
 *                 .domainName(aws_opensearch_domain.remote_domain().domain_name())
 *                 .build())
 *             .build());
 *         var fooInboundConnectionAccepter = new InboundConnectionAccepter("fooInboundConnectionAccepter", InboundConnectionAccepterArgs.builder()
 *             .connectionId(fooOutboundConnection.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import AWS Opensearch Inbound Connection Accepters using the Inbound Connection ID. For example:
 * ```sh
 *  $ pulumi import aws:opensearch/inboundConnectionAccepter:InboundConnectionAccepter foo connection-id
 * ```
 * @property connectionId Specifies the ID of the connection to accept.
 */
public data class InboundConnectionAccepterArgs(
    public val connectionId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.opensearch.InboundConnectionAccepterArgs> {
    override fun toJava(): com.pulumi.aws.opensearch.InboundConnectionAccepterArgs =
        com.pulumi.aws.opensearch.InboundConnectionAccepterArgs.builder()
            .connectionId(connectionId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InboundConnectionAccepterArgs].
 */
@PulumiTagMarker
public class InboundConnectionAccepterArgsBuilder internal constructor() {
    private var connectionId: Output<String>? = null

    /**
     * @param value Specifies the ID of the connection to accept.
     */
    @JvmName("llwshevcrqmnaafr")
    public suspend fun connectionId(`value`: Output<String>) {
        this.connectionId = value
    }

    /**
     * @param value Specifies the ID of the connection to accept.
     */
    @JvmName("mpaxdxealdabtnfn")
    public suspend fun connectionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionId = mapped
    }

    internal fun build(): InboundConnectionAccepterArgs = InboundConnectionAccepterArgs(
        connectionId = connectionId,
    )
}
