@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin

import com.pulumi.aws.opensearch.kotlin.outputs.OutboundConnectionConnectionProperties
import com.pulumi.aws.opensearch.kotlin.outputs.OutboundConnectionLocalDomainInfo
import com.pulumi.aws.opensearch.kotlin.outputs.OutboundConnectionRemoteDomainInfo
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.opensearch.kotlin.outputs.OutboundConnectionConnectionProperties.Companion.toKotlin as outboundConnectionConnectionPropertiesToKotlin
import com.pulumi.aws.opensearch.kotlin.outputs.OutboundConnectionLocalDomainInfo.Companion.toKotlin as outboundConnectionLocalDomainInfoToKotlin
import com.pulumi.aws.opensearch.kotlin.outputs.OutboundConnectionRemoteDomainInfo.Companion.toKotlin as outboundConnectionRemoteDomainInfoToKotlin

/**
 * Builder for [OutboundConnection].
 */
@PulumiTagMarker
public class OutboundConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OutboundConnectionArgs = OutboundConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OutboundConnectionArgsBuilder.() -> Unit) {
        val builder = OutboundConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): OutboundConnection {
        val builtJavaResource = com.pulumi.aws.opensearch.OutboundConnection(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return OutboundConnection(builtJavaResource)
    }
}

/**
 * Manages an AWS Opensearch Outbound Connection.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.opensearch.OutboundConnection;
 * import com.pulumi.aws.opensearch.OutboundConnectionArgs;
 * import com.pulumi.aws.opensearch.inputs.OutboundConnectionLocalDomainInfoArgs;
 * import com.pulumi.aws.opensearch.inputs.OutboundConnectionRemoteDomainInfoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var currentCallerIdentity = AwsFunctions.getCallerIdentity();
 *         final var currentRegion = AwsFunctions.getRegion();
 *         var foo = new OutboundConnection("foo", OutboundConnectionArgs.builder()
 *             .connectionAlias("outbound_connection")
 *             .connectionMode("DIRECT")
 *             .localDomainInfo(OutboundConnectionLocalDomainInfoArgs.builder()
 *                 .ownerId(currentCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))
 *                 .region(currentRegion.applyValue(getRegionResult -> getRegionResult.name()))
 *                 .domainName(aws_opensearch_domain.local_domain().domain_name())
 *                 .build())
 *             .remoteDomainInfo(OutboundConnectionRemoteDomainInfoArgs.builder()
 *                 .ownerId(currentCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))
 *                 .region(currentRegion.applyValue(getRegionResult -> getRegionResult.name()))
 *                 .domainName(aws_opensearch_domain.remote_domain().domain_name())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import AWS Opensearch Outbound Connections using the Outbound Connection ID. For example:
 * ```sh
 *  $ pulumi import aws:opensearch/outboundConnection:OutboundConnection foo connection-id
 * ```
 *
 */
public class OutboundConnection internal constructor(
    override val javaResource: com.pulumi.aws.opensearch.OutboundConnection,
) : KotlinCustomResource(javaResource, OutboundConnectionMapper) {
    /**
     * Accepts the connection.
     */
    public val acceptConnection: Output<Boolean>?
        get() = javaResource.acceptConnection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies the connection alias that will be used by the customer for this connection.
     */
    public val connectionAlias: Output<String>
        get() = javaResource.connectionAlias().applyValue({ args0 -> args0 })

    /**
     * Specifies the connection mode. Accepted values are `DIRECT` or `VPC_ENDPOINT`.
     */
    public val connectionMode: Output<String>?
        get() = javaResource.connectionMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Configuration block for the outbound connection.
     */
    public val connectionProperties: Output<OutboundConnectionConnectionProperties>
        get() = javaResource.connectionProperties().applyValue({ args0 ->
            args0.let({ args0 ->
                outboundConnectionConnectionPropertiesToKotlin(args0)
            })
        })

    /**
     * Status of the connection request.
     */
    public val connectionStatus: Output<String>
        get() = javaResource.connectionStatus().applyValue({ args0 -> args0 })

    /**
     * Configuration block for the local Opensearch domain.
     */
    public val localDomainInfo: Output<OutboundConnectionLocalDomainInfo>
        get() = javaResource.localDomainInfo().applyValue({ args0 ->
            args0.let({ args0 ->
                outboundConnectionLocalDomainInfoToKotlin(args0)
            })
        })

    /**
     * Configuration block for the remote Opensearch domain.
     */
    public val remoteDomainInfo: Output<OutboundConnectionRemoteDomainInfo>
        get() = javaResource.remoteDomainInfo().applyValue({ args0 ->
            args0.let({ args0 ->
                outboundConnectionRemoteDomainInfoToKotlin(args0)
            })
        })
}

public object OutboundConnectionMapper : ResourceMapper<OutboundConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.opensearch.OutboundConnection::class == javaResource::class

    override fun map(javaResource: Resource): OutboundConnection = OutboundConnection(
        javaResource as
            com.pulumi.aws.opensearch.OutboundConnection,
    )
}

/**
 * @see [OutboundConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [OutboundConnection].
 */
public suspend fun outboundConnection(
    name: String,
    block: suspend OutboundConnectionResourceBuilder.() -> Unit,
): OutboundConnection {
    val builder = OutboundConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [OutboundConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun outboundConnection(name: String): OutboundConnection {
    val builder = OutboundConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
