@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin

import com.pulumi.aws.opensearch.OutboundConnectionArgs.builder
import com.pulumi.aws.opensearch.kotlin.inputs.OutboundConnectionConnectionPropertiesArgs
import com.pulumi.aws.opensearch.kotlin.inputs.OutboundConnectionConnectionPropertiesArgsBuilder
import com.pulumi.aws.opensearch.kotlin.inputs.OutboundConnectionLocalDomainInfoArgs
import com.pulumi.aws.opensearch.kotlin.inputs.OutboundConnectionLocalDomainInfoArgsBuilder
import com.pulumi.aws.opensearch.kotlin.inputs.OutboundConnectionRemoteDomainInfoArgs
import com.pulumi.aws.opensearch.kotlin.inputs.OutboundConnectionRemoteDomainInfoArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Manages an AWS Opensearch Outbound Connection.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.opensearch.OutboundConnection;
 * import com.pulumi.aws.opensearch.OutboundConnectionArgs;
 * import com.pulumi.aws.opensearch.inputs.OutboundConnectionLocalDomainInfoArgs;
 * import com.pulumi.aws.opensearch.inputs.OutboundConnectionRemoteDomainInfoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var currentCallerIdentity = AwsFunctions.getCallerIdentity();
 *         final var currentRegion = AwsFunctions.getRegion();
 *         var foo = new OutboundConnection("foo", OutboundConnectionArgs.builder()
 *             .connectionAlias("outbound_connection")
 *             .connectionMode("DIRECT")
 *             .localDomainInfo(OutboundConnectionLocalDomainInfoArgs.builder()
 *                 .ownerId(currentCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))
 *                 .region(currentRegion.applyValue(getRegionResult -> getRegionResult.name()))
 *                 .domainName(aws_opensearch_domain.local_domain().domain_name())
 *                 .build())
 *             .remoteDomainInfo(OutboundConnectionRemoteDomainInfoArgs.builder()
 *                 .ownerId(currentCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))
 *                 .region(currentRegion.applyValue(getRegionResult -> getRegionResult.name()))
 *                 .domainName(aws_opensearch_domain.remote_domain().domain_name())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import AWS Opensearch Outbound Connections using the Outbound Connection ID. For example:
 * ```sh
 *  $ pulumi import aws:opensearch/outboundConnection:OutboundConnection foo connection-id
 * ```
 * @property acceptConnection Accepts the connection.
 * @property connectionAlias Specifies the connection alias that will be used by the customer for this connection.
 * @property connectionMode Specifies the connection mode. Accepted values are `DIRECT` or `VPC_ENDPOINT`.
 * @property connectionProperties Configuration block for the outbound connection.
 * @property localDomainInfo Configuration block for the local Opensearch domain.
 * @property remoteDomainInfo Configuration block for the remote Opensearch domain.
 */
public data class OutboundConnectionArgs(
    public val acceptConnection: Output<Boolean>? = null,
    public val connectionAlias: Output<String>? = null,
    public val connectionMode: Output<String>? = null,
    public val connectionProperties: Output<OutboundConnectionConnectionPropertiesArgs>? = null,
    public val localDomainInfo: Output<OutboundConnectionLocalDomainInfoArgs>? = null,
    public val remoteDomainInfo: Output<OutboundConnectionRemoteDomainInfoArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.opensearch.OutboundConnectionArgs> {
    override fun toJava(): com.pulumi.aws.opensearch.OutboundConnectionArgs =
        com.pulumi.aws.opensearch.OutboundConnectionArgs.builder()
            .acceptConnection(acceptConnection?.applyValue({ args0 -> args0 }))
            .connectionAlias(connectionAlias?.applyValue({ args0 -> args0 }))
            .connectionMode(connectionMode?.applyValue({ args0 -> args0 }))
            .connectionProperties(
                connectionProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .localDomainInfo(localDomainInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .remoteDomainInfo(
                remoteDomainInfo?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [OutboundConnectionArgs].
 */
@PulumiTagMarker
public class OutboundConnectionArgsBuilder internal constructor() {
    private var acceptConnection: Output<Boolean>? = null

    private var connectionAlias: Output<String>? = null

    private var connectionMode: Output<String>? = null

    private var connectionProperties: Output<OutboundConnectionConnectionPropertiesArgs>? = null

    private var localDomainInfo: Output<OutboundConnectionLocalDomainInfoArgs>? = null

    private var remoteDomainInfo: Output<OutboundConnectionRemoteDomainInfoArgs>? = null

    /**
     * @param value Accepts the connection.
     */
    @JvmName("eshrhpxnxekdogqi")
    public suspend fun acceptConnection(`value`: Output<Boolean>) {
        this.acceptConnection = value
    }

    /**
     * @param value Specifies the connection alias that will be used by the customer for this connection.
     */
    @JvmName("qrmmfbmacpihlkjl")
    public suspend fun connectionAlias(`value`: Output<String>) {
        this.connectionAlias = value
    }

    /**
     * @param value Specifies the connection mode. Accepted values are `DIRECT` or `VPC_ENDPOINT`.
     */
    @JvmName("epjrjbtkynuxriam")
    public suspend fun connectionMode(`value`: Output<String>) {
        this.connectionMode = value
    }

    /**
     * @param value Configuration block for the outbound connection.
     */
    @JvmName("bghcohkhcleukmnn")
    public suspend
    fun connectionProperties(`value`: Output<OutboundConnectionConnectionPropertiesArgs>) {
        this.connectionProperties = value
    }

    /**
     * @param value Configuration block for the local Opensearch domain.
     */
    @JvmName("yumytouhdvchdoua")
    public suspend fun localDomainInfo(`value`: Output<OutboundConnectionLocalDomainInfoArgs>) {
        this.localDomainInfo = value
    }

    /**
     * @param value Configuration block for the remote Opensearch domain.
     */
    @JvmName("rdhkxsempioxpgfw")
    public suspend fun remoteDomainInfo(`value`: Output<OutboundConnectionRemoteDomainInfoArgs>) {
        this.remoteDomainInfo = value
    }

    /**
     * @param value Accepts the connection.
     */
    @JvmName("yhchjgbgbrxhdsjb")
    public suspend fun acceptConnection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceptConnection = mapped
    }

    /**
     * @param value Specifies the connection alias that will be used by the customer for this connection.
     */
    @JvmName("ndrguqahfndajatp")
    public suspend fun connectionAlias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionAlias = mapped
    }

    /**
     * @param value Specifies the connection mode. Accepted values are `DIRECT` or `VPC_ENDPOINT`.
     */
    @JvmName("yrnhyaswsuidrnys")
    public suspend fun connectionMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionMode = mapped
    }

    /**
     * @param value Configuration block for the outbound connection.
     */
    @JvmName("tmnsbuubkgnyrjct")
    public suspend fun connectionProperties(`value`: OutboundConnectionConnectionPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionProperties = mapped
    }

    /**
     * @param argument Configuration block for the outbound connection.
     */
    @JvmName("aosrhqvtuajuudbb")
    public suspend
    fun connectionProperties(argument: suspend OutboundConnectionConnectionPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = OutboundConnectionConnectionPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.connectionProperties = mapped
    }

    /**
     * @param value Configuration block for the local Opensearch domain.
     */
    @JvmName("lqbjtcsdtkqxofom")
    public suspend fun localDomainInfo(`value`: OutboundConnectionLocalDomainInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localDomainInfo = mapped
    }

    /**
     * @param argument Configuration block for the local Opensearch domain.
     */
    @JvmName("alkietyitecrsrpt")
    public suspend
    fun localDomainInfo(argument: suspend OutboundConnectionLocalDomainInfoArgsBuilder.() -> Unit) {
        val toBeMapped = OutboundConnectionLocalDomainInfoArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.localDomainInfo = mapped
    }

    /**
     * @param value Configuration block for the remote Opensearch domain.
     */
    @JvmName("ptblggqljnqoiyky")
    public suspend fun remoteDomainInfo(`value`: OutboundConnectionRemoteDomainInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remoteDomainInfo = mapped
    }

    /**
     * @param argument Configuration block for the remote Opensearch domain.
     */
    @JvmName("sillxgwbcvnamjrp")
    public suspend
    fun remoteDomainInfo(argument: suspend OutboundConnectionRemoteDomainInfoArgsBuilder.() -> Unit) {
        val toBeMapped = OutboundConnectionRemoteDomainInfoArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.remoteDomainInfo = mapped
    }

    internal fun build(): OutboundConnectionArgs = OutboundConnectionArgs(
        acceptConnection = acceptConnection,
        connectionAlias = connectionAlias,
        connectionMode = connectionMode,
        connectionProperties = connectionProperties,
        localDomainInfo = localDomainInfo,
        remoteDomainInfo = remoteDomainInfo,
    )
}
