@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin

import com.pulumi.aws.opensearch.kotlin.outputs.PackagePackageSource
import com.pulumi.aws.opensearch.kotlin.outputs.PackagePackageSource.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Package].
 */
@PulumiTagMarker
public class PackageResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PackageArgs = PackageArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PackageArgsBuilder.() -> Unit) {
        val builder = PackageArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Package {
        val builtJavaResource = com.pulumi.aws.opensearch.Package(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Package(builtJavaResource)
    }
}

/**
 * Manages an AWS Opensearch Package.
 * {{% examples %}}
 * ## Example Usage
 * {{% /examples %}}
 * ## Import
 * Using `pulumi import`, import AWS Opensearch Packages using the Package ID. For example:
 * ```sh
 *  $ pulumi import aws:opensearch/package:Package example package-id
 * ```
 *
 */
public class Package internal constructor(
    override val javaResource: com.pulumi.aws.opensearch.Package,
) : KotlinCustomResource(javaResource, PackageMapper) {
    /**
     * The current version of the package.
     */
    public val availablePackageVersion: Output<String>
        get() = javaResource.availablePackageVersion().applyValue({ args0 -> args0 })

    /**
     * Description of the package.
     */
    public val packageDescription: Output<String>?
        get() = javaResource.packageDescription().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val packageId: Output<String>
        get() = javaResource.packageId().applyValue({ args0 -> args0 })

    /**
     * Unique name for the package.
     */
    public val packageName: Output<String>
        get() = javaResource.packageName().applyValue({ args0 -> args0 })

    /**
     * Configuration block for the package source options.
     */
    public val packageSource: Output<PackagePackageSource>
        get() = javaResource.packageSource().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * The type of package.
     */
    public val packageType: Output<String>
        get() = javaResource.packageType().applyValue({ args0 -> args0 })
}

public object PackageMapper : ResourceMapper<Package> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.opensearch.Package::class == javaResource::class

    override fun map(javaResource: Resource): Package = Package(
        javaResource as
            com.pulumi.aws.opensearch.Package,
    )
}

/**
 * @see [Package].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Package].
 */
public suspend fun `package`(name: String, block: suspend PackageResourceBuilder.() -> Unit):
    Package {
    val builder = PackageResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Package].
 * @param name The _unique_ name of the resulting resource.
 */
public fun `package`(name: String): Package {
    val builder = PackageResourceBuilder()
    builder.name(name)
    return builder.build()
}
