@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin

import com.pulumi.aws.opensearch.PackageArgs.builder
import com.pulumi.aws.opensearch.kotlin.inputs.PackagePackageSourceArgs
import com.pulumi.aws.opensearch.kotlin.inputs.PackagePackageSourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Manages an AWS Opensearch Package.
 * {{% examples %}}
 * ## Example Usage
 * {{% /examples %}}
 * ## Import
 * Using `pulumi import`, import AWS Opensearch Packages using the Package ID. For example:
 * ```sh
 *  $ pulumi import aws:opensearch/package:Package example package-id
 * ```
 * @property packageDescription Description of the package.
 * @property packageName Unique name for the package.
 * @property packageSource Configuration block for the package source options.
 * @property packageType The type of package.
 */
public data class PackageArgs(
    public val packageDescription: Output<String>? = null,
    public val packageName: Output<String>? = null,
    public val packageSource: Output<PackagePackageSourceArgs>? = null,
    public val packageType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.opensearch.PackageArgs> {
    override fun toJava(): com.pulumi.aws.opensearch.PackageArgs =
        com.pulumi.aws.opensearch.PackageArgs.builder()
            .packageDescription(packageDescription?.applyValue({ args0 -> args0 }))
            .packageName(packageName?.applyValue({ args0 -> args0 }))
            .packageSource(packageSource?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .packageType(packageType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PackageArgs].
 */
@PulumiTagMarker
public class PackageArgsBuilder internal constructor() {
    private var packageDescription: Output<String>? = null

    private var packageName: Output<String>? = null

    private var packageSource: Output<PackagePackageSourceArgs>? = null

    private var packageType: Output<String>? = null

    /**
     * @param value Description of the package.
     */
    @JvmName("imjuxhtudhiubcyn")
    public suspend fun packageDescription(`value`: Output<String>) {
        this.packageDescription = value
    }

    /**
     * @param value Unique name for the package.
     */
    @JvmName("leibtqmarvoqfsfj")
    public suspend fun packageName(`value`: Output<String>) {
        this.packageName = value
    }

    /**
     * @param value Configuration block for the package source options.
     */
    @JvmName("snbduhjrusaqwfiq")
    public suspend fun packageSource(`value`: Output<PackagePackageSourceArgs>) {
        this.packageSource = value
    }

    /**
     * @param value The type of package.
     */
    @JvmName("eornqtysfldmsmru")
    public suspend fun packageType(`value`: Output<String>) {
        this.packageType = value
    }

    /**
     * @param value Description of the package.
     */
    @JvmName("xwgbxnpiiunyoqim")
    public suspend fun packageDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageDescription = mapped
    }

    /**
     * @param value Unique name for the package.
     */
    @JvmName("hnclnjnmbdcffpjx")
    public suspend fun packageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageName = mapped
    }

    /**
     * @param value Configuration block for the package source options.
     */
    @JvmName("oplshyotsvoqmhkf")
    public suspend fun packageSource(`value`: PackagePackageSourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageSource = mapped
    }

    /**
     * @param argument Configuration block for the package source options.
     */
    @JvmName("rebnacoeemdfbaqc")
    public suspend fun packageSource(argument: suspend PackagePackageSourceArgsBuilder.() -> Unit) {
        val toBeMapped = PackagePackageSourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.packageSource = mapped
    }

    /**
     * @param value The type of package.
     */
    @JvmName("nldfridrgulvjmam")
    public suspend fun packageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageType = mapped
    }

    internal fun build(): PackageArgs = PackageArgs(
        packageDescription = packageDescription,
        packageName = packageName,
        packageSource = packageSource,
        packageType = packageType,
    )
}
