@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [PackageAssociation].
 */
@PulumiTagMarker
public class PackageAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PackageAssociationArgs = PackageAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PackageAssociationArgsBuilder.() -> Unit) {
        val builder = PackageAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PackageAssociation {
        val builtJavaResource = com.pulumi.aws.opensearch.PackageAssociation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PackageAssociation(builtJavaResource)
    }
}

/**
 * Manages an AWS Opensearch Package Association.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opensearch.Domain;
 * import com.pulumi.aws.opensearch.DomainArgs;
 * import com.pulumi.aws.opensearch.inputs.DomainClusterConfigArgs;
 * import com.pulumi.aws.opensearch.Package;
 * import com.pulumi.aws.opensearch.PackageArgs;
 * import com.pulumi.aws.opensearch.inputs.PackagePackageSourceArgs;
 * import com.pulumi.aws.opensearch.PackageAssociation;
 * import com.pulumi.aws.opensearch.PackageAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myDomain = new Domain("myDomain", DomainArgs.builder()
 *             .engineVersion("Elasticsearch_7.10")
 *             .clusterConfig(DomainClusterConfigArgs.builder()
 *                 .instanceType("r4.large.search")
 *                 .build())
 *             .build());
 *         var examplePackage = new Package("examplePackage", PackageArgs.builder()
 *             .packageName("example-txt")
 *             .packageSource(PackagePackageSourceArgs.builder()
 *                 .s3BucketName(aws_s3_bucket.my_opensearch_packages().bucket())
 *                 .s3Key(aws_s3_object.example().key())
 *                 .build())
 *             .packageType("TXT-DICTIONARY")
 *             .build());
 *         var examplePackageAssociation = new PackageAssociation("examplePackageAssociation", PackageAssociationArgs.builder()
 *             .packageId(examplePackage.id())
 *             .domainName(myDomain.domainName())
 *             .build());
 *     }
 * }
 * ```
 */
public class PackageAssociation internal constructor(
    override val javaResource: com.pulumi.aws.opensearch.PackageAssociation,
) : KotlinCustomResource(javaResource, PackageAssociationMapper) {
    /**
     * Name of the domain to associate the package with.
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })

    /**
     * Internal ID of the package to associate with a domain.
     */
    public val packageId: Output<String>
        get() = javaResource.packageId().applyValue({ args0 -> args0 })

    public val referencePath: Output<String>
        get() = javaResource.referencePath().applyValue({ args0 -> args0 })
}

public object PackageAssociationMapper : ResourceMapper<PackageAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.opensearch.PackageAssociation::class == javaResource::class

    override fun map(javaResource: Resource): PackageAssociation = PackageAssociation(
        javaResource as
            com.pulumi.aws.opensearch.PackageAssociation,
    )
}

/**
 * @see [PackageAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PackageAssociation].
 */
public suspend fun packageAssociation(
    name: String,
    block: suspend PackageAssociationResourceBuilder.() -> Unit,
): PackageAssociation {
    val builder = PackageAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PackageAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun packageAssociation(name: String): PackageAssociation {
    val builder = PackageAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
