@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin

import com.pulumi.aws.opensearch.PackageAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages an AWS Opensearch Package Association.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opensearch.Domain;
 * import com.pulumi.aws.opensearch.DomainArgs;
 * import com.pulumi.aws.opensearch.inputs.DomainClusterConfigArgs;
 * import com.pulumi.aws.opensearch.Package;
 * import com.pulumi.aws.opensearch.PackageArgs;
 * import com.pulumi.aws.opensearch.inputs.PackagePackageSourceArgs;
 * import com.pulumi.aws.opensearch.PackageAssociation;
 * import com.pulumi.aws.opensearch.PackageAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myDomain = new Domain("myDomain", DomainArgs.builder()
 *             .engineVersion("Elasticsearch_7.10")
 *             .clusterConfig(DomainClusterConfigArgs.builder()
 *                 .instanceType("r4.large.search")
 *                 .build())
 *             .build());
 *         var examplePackage = new Package("examplePackage", PackageArgs.builder()
 *             .packageName("example-txt")
 *             .packageSource(PackagePackageSourceArgs.builder()
 *                 .s3BucketName(aws_s3_bucket.my_opensearch_packages().bucket())
 *                 .s3Key(aws_s3_object.example().key())
 *                 .build())
 *             .packageType("TXT-DICTIONARY")
 *             .build());
 *         var examplePackageAssociation = new PackageAssociation("examplePackageAssociation", PackageAssociationArgs.builder()
 *             .packageId(examplePackage.id())
 *             .domainName(myDomain.domainName())
 *             .build());
 *     }
 * }
 * ```
 * @property domainName Name of the domain to associate the package with.
 * @property packageId Internal ID of the package to associate with a domain.
 */
public data class PackageAssociationArgs(
    public val domainName: Output<String>? = null,
    public val packageId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.opensearch.PackageAssociationArgs> {
    override fun toJava(): com.pulumi.aws.opensearch.PackageAssociationArgs =
        com.pulumi.aws.opensearch.PackageAssociationArgs.builder()
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .packageId(packageId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PackageAssociationArgs].
 */
@PulumiTagMarker
public class PackageAssociationArgsBuilder internal constructor() {
    private var domainName: Output<String>? = null

    private var packageId: Output<String>? = null

    /**
     * @param value Name of the domain to associate the package with.
     */
    @JvmName("wrvtalvkldkjidim")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value Internal ID of the package to associate with a domain.
     */
    @JvmName("cllvabfbexpbowwi")
    public suspend fun packageId(`value`: Output<String>) {
        this.packageId = value
    }

    /**
     * @param value Name of the domain to associate the package with.
     */
    @JvmName("cmeklpbfgylcfmpk")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value Internal ID of the package to associate with a domain.
     */
    @JvmName("fcrurvtmrayaghuk")
    public suspend fun packageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageId = mapped
    }

    internal fun build(): PackageAssociationArgs = PackageAssociationArgs(
        domainName = domainName,
        packageId = packageId,
    )
}
