@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin

import com.pulumi.aws.opensearch.ServerlessAccessPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS OpenSearch Serverless Access Policy. See AWS documentation for [data access policies](https://docs&#46;aws&#46;amazon&#46;com/opensearch-service/latest/developerguide/serverless-data-access&#46;html) and [supported data access policy permissions](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html#serverless-data-supported-permissions).
 * ## Example Usage
 * ### Grant all collection and index permissions
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.opensearch.ServerlessAccessPolicy;
 * import com.pulumi.aws.opensearch.ServerlessAccessPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 *         var example = new ServerlessAccessPolicy("example", ServerlessAccessPolicyArgs.builder()
 *             .type("data")
 *             .description("read and write permissions")
 *             .policy(serializeJson(
 *                 jsonArray(jsonObject(
 *                     jsonProperty("Rules", jsonArray(
 *                         jsonObject(
 *                             jsonProperty("ResourceType", "index"),
 *                             jsonProperty("Resource", jsonArray("index/example-collection/*")),
 *                             jsonProperty("Permission", jsonArray("aoss:*"))
 *                         ),
 *                         jsonObject(
 *                             jsonProperty("ResourceType", "collection"),
 *                             jsonProperty("Resource", jsonArray("collection/example-collection")),
 *                             jsonProperty("Permission", jsonArray("aoss:*"))
 *                         )
 *                     )),
 *                     jsonProperty("Principal", jsonArray(current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.arn())))
 *                 ))))
 *             .build());
 *     }
 * }
 * ```
 * ### Grant read-only collection and index permissions
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.opensearch.ServerlessAccessPolicy;
 * import com.pulumi.aws.opensearch.ServerlessAccessPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 *         var example = new ServerlessAccessPolicy("example", ServerlessAccessPolicyArgs.builder()
 *             .type("data")
 *             .description("read-only permissions")
 *             .policy(serializeJson(
 *                 jsonArray(jsonObject(
 *                     jsonProperty("Rules", jsonArray(
 *                         jsonObject(
 *                             jsonProperty("ResourceType", "index"),
 *                             jsonProperty("Resource", jsonArray("index/example-collection/*")),
 *                             jsonProperty("Permission", jsonArray(
 *                                 "aoss:DescribeIndex",
 *                                 "aoss:ReadDocument"
 *                             ))
 *                         ),
 *                         jsonObject(
 *                             jsonProperty("ResourceType", "collection"),
 *                             jsonProperty("Resource", jsonArray("collection/example-collection")),
 *                             jsonProperty("Permission", jsonArray("aoss:DescribeCollectionItems"))
 *                         )
 *                     )),
 *                     jsonProperty("Principal", jsonArray(current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.arn())))
 *                 ))))
 *             .build());
 *     }
 * }
 * ```
 * ### Grant SAML identity permissions
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opensearch.ServerlessAccessPolicy;
 * import com.pulumi.aws.opensearch.ServerlessAccessPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ServerlessAccessPolicy("example", ServerlessAccessPolicyArgs.builder()
 *             .type("data")
 *             .description("saml permissions")
 *             .policy(serializeJson(
 *                 jsonArray(jsonObject(
 *                     jsonProperty("Rules", jsonArray(
 *                         jsonObject(
 *                             jsonProperty("ResourceType", "index"),
 *                             jsonProperty("Resource", jsonArray("index/example-collection/*")),
 *                             jsonProperty("Permission", jsonArray("aoss:*"))
 *                         ),
 *                         jsonObject(
 *                             jsonProperty("ResourceType", "collection"),
 *                             jsonProperty("Resource", jsonArray("collection/example-collection")),
 *                             jsonProperty("Permission", jsonArray("aoss:*"))
 *                         )
 *                     )),
 *                     jsonProperty("Principal", jsonArray(
 *                         "saml/123456789012/myprovider/user/Annie",
 *                         "saml/123456789012/anotherprovider/group/Accounting"
 *                     ))
 *                 ))))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import OpenSearchServerless Access Policy using the `name` and `type` arguments separated by a slash (`/`). For example:
 * ```sh
 *  $ pulumi import aws:opensearch/serverlessAccessPolicy:ServerlessAccessPolicy example example/data
 * ```
 * @property description Description of the policy. Typically used to store information about the permissions defined in the policy.
 * @property name Name of the policy.
 * @property policy JSON policy document to use as the content for the new policy
 * @property type Type of access policy. Must be `data`.
 * The following arguments are optional:
 * */*/*/
 */
public data class ServerlessAccessPolicyArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val policy: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.opensearch.ServerlessAccessPolicyArgs> {
    override fun toJava(): com.pulumi.aws.opensearch.ServerlessAccessPolicyArgs =
        com.pulumi.aws.opensearch.ServerlessAccessPolicyArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServerlessAccessPolicyArgs].
 */
@PulumiTagMarker
public class ServerlessAccessPolicyArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var policy: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Description of the policy. Typically used to store information about the permissions defined in the policy.
     */
    @JvmName("rleabqsvjletihiq")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name of the policy.
     */
    @JvmName("nubywlbdogfcwnov")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value JSON policy document to use as the content for the new policy
     */
    @JvmName("roiejcrihwsculgt")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value Type of access policy. Must be `data`.
     * The following arguments are optional:
     */
    @JvmName("pbeteegnnmlsgdol")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Description of the policy. Typically used to store information about the permissions defined in the policy.
     */
    @JvmName("cncbbqgansrjnevj")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name of the policy.
     */
    @JvmName("qjgapotkqgkvrwsn")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value JSON policy document to use as the content for the new policy
     */
    @JvmName("wigabsjfdmsoqecg")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value Type of access policy. Must be `data`.
     * The following arguments are optional:
     */
    @JvmName("dpifwyrwplxrckna")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ServerlessAccessPolicyArgs = ServerlessAccessPolicyArgs(
        description = description,
        name = name,
        policy = policy,
        type = type,
    )
}
