@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ServerlessLifecyclePolicy].
 */
@PulumiTagMarker
public class ServerlessLifecyclePolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServerlessLifecyclePolicyArgs = ServerlessLifecyclePolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServerlessLifecyclePolicyArgsBuilder.() -> Unit) {
        val builder = ServerlessLifecyclePolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ServerlessLifecyclePolicy {
        val builtJavaResource =
            com.pulumi.aws.opensearch.ServerlessLifecyclePolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ServerlessLifecyclePolicy(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS OpenSearch Serverless Lifecycle Policy. See AWS documentation for [lifecycle policies](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html).
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opensearch.ServerlessLifecyclePolicy;
 * import com.pulumi.aws.opensearch.ServerlessLifecyclePolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ServerlessLifecyclePolicy("example", ServerlessLifecyclePolicyArgs.builder()
 *             .type("retention")
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Rules", jsonArray(
 *                         jsonObject(
 *                             jsonProperty("ResourceType", "index"),
 *                             jsonProperty("Resource", jsonArray("index/autoparts-inventory/*")),
 *                             jsonProperty("MinIndexRetention", "81d")
 *                         ),
 *                         jsonObject(
 *                             jsonProperty("ResourceType", "index"),
 *                             jsonProperty("Resource", jsonArray("index/sales/orders*")),
 *                             jsonProperty("NoMinIndexRetention", true)
 *                         )
 *                     ))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import OpenSearch Serverless Lifecycle Policy using the `name` and `type` arguments separated by a slash (`/`). For example:
 * ```sh
 *  $ pulumi import aws:opensearch/serverlessLifecyclePolicy:ServerlessLifecyclePolicy example example/retention
 * ```
 * */
 */
public class ServerlessLifecyclePolicy internal constructor(
    override val javaResource: com.pulumi.aws.opensearch.ServerlessLifecyclePolicy,
) : KotlinCustomResource(javaResource, ServerlessLifecyclePolicyMapper) {
    /**
     * Description of the policy.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the policy.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * JSON policy document to use as the content for the new policy.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })

    /**
     * Version of the policy.
     */
    public val policyVersion: Output<String>
        get() = javaResource.policyVersion().applyValue({ args0 -> args0 })

    /**
     * Type of lifecycle policy. Must be `retention`.
     * The following arguments are optional:
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ServerlessLifecyclePolicyMapper : ResourceMapper<ServerlessLifecyclePolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.opensearch.ServerlessLifecyclePolicy::class == javaResource::class

    override fun map(javaResource: Resource): ServerlessLifecyclePolicy =
        ServerlessLifecyclePolicy(javaResource as com.pulumi.aws.opensearch.ServerlessLifecyclePolicy)
}

/**
 * @see [ServerlessLifecyclePolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServerlessLifecyclePolicy].
 */
public suspend fun serverlessLifecyclePolicy(
    name: String,
    block: suspend ServerlessLifecyclePolicyResourceBuilder.() -> Unit,
): ServerlessLifecyclePolicy {
    val builder = ServerlessLifecyclePolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServerlessLifecyclePolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serverlessLifecyclePolicy(name: String): ServerlessLifecyclePolicy {
    val builder = ServerlessLifecyclePolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
