@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ServerlessSecurityPolicy].
 */
@PulumiTagMarker
public class ServerlessSecurityPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServerlessSecurityPolicyArgs = ServerlessSecurityPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServerlessSecurityPolicyArgsBuilder.() -> Unit) {
        val builder = ServerlessSecurityPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ServerlessSecurityPolicy {
        val builtJavaResource =
            com.pulumi.aws.opensearch.ServerlessSecurityPolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ServerlessSecurityPolicy(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS OpenSearch Serverless Security Policy. See AWS documentation for [encryption policies](https://docs&#46;aws&#46;amazon&#46;com/opensearch-service/latest/developerguide/serverless-encryption&#46;html#serverless-encryption-policies) and [network policies](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-network.html#serverless-network-policies).
 * ## Example Usage
 * ### Encryption Security Policy
 * ### Applies to a single collection
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opensearch.ServerlessSecurityPolicy;
 * import com.pulumi.aws.opensearch.ServerlessSecurityPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ServerlessSecurityPolicy("example", ServerlessSecurityPolicyArgs.builder()
 *             .type("encryption")
 *             .description("encryption security policy for example-collection")
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Rules", jsonArray(jsonObject(
 *                         jsonProperty("Resource", jsonArray("collection/example-collection")),
 *                         jsonProperty("ResourceType", "collection")
 *                     ))),
 *                     jsonProperty("AWSOwnedKey", true)
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ### Applies to multiple collections
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opensearch.ServerlessSecurityPolicy;
 * import com.pulumi.aws.opensearch.ServerlessSecurityPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ServerlessSecurityPolicy("example", ServerlessSecurityPolicyArgs.builder()
 *             .type("encryption")
 *             .description("encryption security policy for collections that begin with \"example\"")
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Rules", jsonArray(jsonObject(
 *                         jsonProperty("Resource", jsonArray("collection/example*")),
 *                         jsonProperty("ResourceType", "collection")
 *                     ))),
 *                     jsonProperty("AWSOwnedKey", true)
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ### Using a customer managed key
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opensearch.ServerlessSecurityPolicy;
 * import com.pulumi.aws.opensearch.ServerlessSecurityPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ServerlessSecurityPolicy("example", ServerlessSecurityPolicyArgs.builder()
 *             .type("encryption")
 *             .description("encryption security policy using customer KMS key")
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Rules", jsonArray(jsonObject(
 *                         jsonProperty("Resource", jsonArray("collection/customer-managed-key-collection")),
 *                         jsonProperty("ResourceType", "collection")
 *                     ))),
 *                     jsonProperty("AWSOwnedKey", false),
 *                     jsonProperty("KmsARN", "arn:aws:kms:us-east-1:123456789012:key/93fd6da4-a317-4c17-bfe9-382b5d988b36")
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ### Allow public access to the collection endpoint and the Dashboards endpoint
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opensearch.ServerlessSecurityPolicy;
 * import com.pulumi.aws.opensearch.ServerlessSecurityPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ServerlessSecurityPolicy("example", ServerlessSecurityPolicyArgs.builder()
 *             .type("network")
 *             .description("Public access")
 *             .policy(serializeJson(
 *                 jsonArray(jsonObject(
 *                     jsonProperty("Description", "Public access to collection and Dashboards endpoint for example collection"),
 *                     jsonProperty("Rules", jsonArray(
 *                         jsonObject(
 *                             jsonProperty("ResourceType", "collection"),
 *                             jsonProperty("Resource", jsonArray("collection/example-collection"))
 *                         ),
 *                         jsonObject(
 *                             jsonProperty("ResourceType", "dashboard"),
 *                             jsonProperty("Resource", jsonArray("collection/example-collection"))
 *                         )
 *                     )),
 *                     jsonProperty("AllowFromPublic", true)
 *                 ))))
 *             .build());
 *     }
 * }
 * ```
 * ### Allow VPC access to the collection endpoint and the Dashboards endpoint
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opensearch.ServerlessSecurityPolicy;
 * import com.pulumi.aws.opensearch.ServerlessSecurityPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ServerlessSecurityPolicy("example", ServerlessSecurityPolicyArgs.builder()
 *             .type("network")
 *             .description("VPC access")
 *             .policy(serializeJson(
 *                 jsonArray(jsonObject(
 *                     jsonProperty("Description", "VPC access to collection and Dashboards endpoint for example collection"),
 *                     jsonProperty("Rules", jsonArray(
 *                         jsonObject(
 *                             jsonProperty("ResourceType", "collection"),
 *                             jsonProperty("Resource", jsonArray("collection/example-collection"))
 *                         ),
 *                         jsonObject(
 *                             jsonProperty("ResourceType", "dashboard"),
 *                             jsonProperty("Resource", jsonArray("collection/example-collection"))
 *                         )
 *                     )),
 *                     jsonProperty("AllowFromPublic", false),
 *                     jsonProperty("SourceVPCEs", jsonArray("vpce-050f79086ee71ac05"))
 *                 ))))
 *             .build());
 *     }
 * }
 * ```
 * ### Mixed access for different collections
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opensearch.ServerlessSecurityPolicy;
 * import com.pulumi.aws.opensearch.ServerlessSecurityPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ServerlessSecurityPolicy("example", ServerlessSecurityPolicyArgs.builder()
 *             .type("network")
 *             .description("Mixed access for marketing and sales")
 *             .policy(serializeJson(
 *                 jsonArray(
 *                     jsonObject(
 *                         jsonProperty("Description", "Marketing access"),
 *                         jsonProperty("Rules", jsonArray(
 *                             jsonObject(
 *                                 jsonProperty("ResourceType", "collection"),
 *                                 jsonProperty("Resource", jsonArray("collection/marketing*"))
 *                             ),
 *                             jsonObject(
 *                                 jsonProperty("ResourceType", "dashboard"),
 *                                 jsonProperty("Resource", jsonArray("collection/marketing*"))
 *                             )
 *                         )),
 *                         jsonProperty("AllowFromPublic", false),
 *                         jsonProperty("SourceVPCEs", jsonArray("vpce-050f79086ee71ac05"))
 *                     ),
 *                     jsonObject(
 *                         jsonProperty("Description", "Sales access"),
 *                         jsonProperty("Rules", jsonArray(jsonObject(
 *                             jsonProperty("ResourceType", "collection"),
 *                             jsonProperty("Resource", jsonArray("collection/finance"))
 *                         ))),
 *                         jsonProperty("AllowFromPublic", true)
 *                     )
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import OpenSearchServerless Security Policy using the `name` and `type` arguments separated by a slash (`/`). For example:
 * ```sh
 *  $ pulumi import aws:opensearch/serverlessSecurityPolicy:ServerlessSecurityPolicy example example/encryption
 * ```
 *
 */
public class ServerlessSecurityPolicy internal constructor(
    override val javaResource: com.pulumi.aws.opensearch.ServerlessSecurityPolicy,
) : KotlinCustomResource(javaResource, ServerlessSecurityPolicyMapper) {
    /**
     * Description of the policy. Typically used to store information about the permissions defined in the policy.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the policy.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * JSON policy document to use as the content for the new policy
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })

    /**
     * Version of the policy.
     */
    public val policyVersion: Output<String>
        get() = javaResource.policyVersion().applyValue({ args0 -> args0 })

    /**
     * Type of security policy. One of `encryption` or `network`.
     * The following arguments are optional:
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ServerlessSecurityPolicyMapper : ResourceMapper<ServerlessSecurityPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.opensearch.ServerlessSecurityPolicy::class == javaResource::class

    override fun map(javaResource: Resource): ServerlessSecurityPolicy =
        ServerlessSecurityPolicy(javaResource as com.pulumi.aws.opensearch.ServerlessSecurityPolicy)
}

/**
 * @see [ServerlessSecurityPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServerlessSecurityPolicy].
 */
public suspend fun serverlessSecurityPolicy(
    name: String,
    block: suspend ServerlessSecurityPolicyResourceBuilder.() -> Unit,
): ServerlessSecurityPolicy {
    val builder = ServerlessSecurityPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServerlessSecurityPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serverlessSecurityPolicy(name: String): ServerlessSecurityPolicy {
    val builder = ServerlessSecurityPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
