@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin

import com.pulumi.aws.opensearch.ServerlessSecurityPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS OpenSearch Serverless Security Policy. See AWS documentation for [encryption policies](https://docs&#46;aws&#46;amazon&#46;com/opensearch-service/latest/developerguide/serverless-encryption&#46;html#serverless-encryption-policies) and [network policies](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-network.html#serverless-network-policies).
 * ## Example Usage
 * ### Encryption Security Policy
 * ### Applies to a single collection
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opensearch.ServerlessSecurityPolicy;
 * import com.pulumi.aws.opensearch.ServerlessSecurityPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ServerlessSecurityPolicy("example", ServerlessSecurityPolicyArgs.builder()
 *             .type("encryption")
 *             .description("encryption security policy for example-collection")
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Rules", jsonArray(jsonObject(
 *                         jsonProperty("Resource", jsonArray("collection/example-collection")),
 *                         jsonProperty("ResourceType", "collection")
 *                     ))),
 *                     jsonProperty("AWSOwnedKey", true)
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ### Applies to multiple collections
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opensearch.ServerlessSecurityPolicy;
 * import com.pulumi.aws.opensearch.ServerlessSecurityPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ServerlessSecurityPolicy("example", ServerlessSecurityPolicyArgs.builder()
 *             .type("encryption")
 *             .description("encryption security policy for collections that begin with \"example\"")
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Rules", jsonArray(jsonObject(
 *                         jsonProperty("Resource", jsonArray("collection/example*")),
 *                         jsonProperty("ResourceType", "collection")
 *                     ))),
 *                     jsonProperty("AWSOwnedKey", true)
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ### Using a customer managed key
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opensearch.ServerlessSecurityPolicy;
 * import com.pulumi.aws.opensearch.ServerlessSecurityPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ServerlessSecurityPolicy("example", ServerlessSecurityPolicyArgs.builder()
 *             .type("encryption")
 *             .description("encryption security policy using customer KMS key")
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Rules", jsonArray(jsonObject(
 *                         jsonProperty("Resource", jsonArray("collection/customer-managed-key-collection")),
 *                         jsonProperty("ResourceType", "collection")
 *                     ))),
 *                     jsonProperty("AWSOwnedKey", false),
 *                     jsonProperty("KmsARN", "arn:aws:kms:us-east-1:123456789012:key/93fd6da4-a317-4c17-bfe9-382b5d988b36")
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ### Allow public access to the collection endpoint and the Dashboards endpoint
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opensearch.ServerlessSecurityPolicy;
 * import com.pulumi.aws.opensearch.ServerlessSecurityPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ServerlessSecurityPolicy("example", ServerlessSecurityPolicyArgs.builder()
 *             .type("network")
 *             .description("Public access")
 *             .policy(serializeJson(
 *                 jsonArray(jsonObject(
 *                     jsonProperty("Description", "Public access to collection and Dashboards endpoint for example collection"),
 *                     jsonProperty("Rules", jsonArray(
 *                         jsonObject(
 *                             jsonProperty("ResourceType", "collection"),
 *                             jsonProperty("Resource", jsonArray("collection/example-collection"))
 *                         ),
 *                         jsonObject(
 *                             jsonProperty("ResourceType", "dashboard"),
 *                             jsonProperty("Resource", jsonArray("collection/example-collection"))
 *                         )
 *                     )),
 *                     jsonProperty("AllowFromPublic", true)
 *                 ))))
 *             .build());
 *     }
 * }
 * ```
 * ### Allow VPC access to the collection endpoint and the Dashboards endpoint
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opensearch.ServerlessSecurityPolicy;
 * import com.pulumi.aws.opensearch.ServerlessSecurityPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ServerlessSecurityPolicy("example", ServerlessSecurityPolicyArgs.builder()
 *             .type("network")
 *             .description("VPC access")
 *             .policy(serializeJson(
 *                 jsonArray(jsonObject(
 *                     jsonProperty("Description", "VPC access to collection and Dashboards endpoint for example collection"),
 *                     jsonProperty("Rules", jsonArray(
 *                         jsonObject(
 *                             jsonProperty("ResourceType", "collection"),
 *                             jsonProperty("Resource", jsonArray("collection/example-collection"))
 *                         ),
 *                         jsonObject(
 *                             jsonProperty("ResourceType", "dashboard"),
 *                             jsonProperty("Resource", jsonArray("collection/example-collection"))
 *                         )
 *                     )),
 *                     jsonProperty("AllowFromPublic", false),
 *                     jsonProperty("SourceVPCEs", jsonArray("vpce-050f79086ee71ac05"))
 *                 ))))
 *             .build());
 *     }
 * }
 * ```
 * ### Mixed access for different collections
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opensearch.ServerlessSecurityPolicy;
 * import com.pulumi.aws.opensearch.ServerlessSecurityPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ServerlessSecurityPolicy("example", ServerlessSecurityPolicyArgs.builder()
 *             .type("network")
 *             .description("Mixed access for marketing and sales")
 *             .policy(serializeJson(
 *                 jsonArray(
 *                     jsonObject(
 *                         jsonProperty("Description", "Marketing access"),
 *                         jsonProperty("Rules", jsonArray(
 *                             jsonObject(
 *                                 jsonProperty("ResourceType", "collection"),
 *                                 jsonProperty("Resource", jsonArray("collection/marketing*"))
 *                             ),
 *                             jsonObject(
 *                                 jsonProperty("ResourceType", "dashboard"),
 *                                 jsonProperty("Resource", jsonArray("collection/marketing*"))
 *                             )
 *                         )),
 *                         jsonProperty("AllowFromPublic", false),
 *                         jsonProperty("SourceVPCEs", jsonArray("vpce-050f79086ee71ac05"))
 *                     ),
 *                     jsonObject(
 *                         jsonProperty("Description", "Sales access"),
 *                         jsonProperty("Rules", jsonArray(jsonObject(
 *                             jsonProperty("ResourceType", "collection"),
 *                             jsonProperty("Resource", jsonArray("collection/finance"))
 *                         ))),
 *                         jsonProperty("AllowFromPublic", true)
 *                     )
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import OpenSearchServerless Security Policy using the `name` and `type` arguments separated by a slash (`/`). For example:
 * ```sh
 *  $ pulumi import aws:opensearch/serverlessSecurityPolicy:ServerlessSecurityPolicy example example/encryption
 * ```
 * @property description Description of the policy. Typically used to store information about the permissions defined in the policy.
 * @property name Name of the policy.
 * @property policy JSON policy document to use as the content for the new policy
 * @property type Type of security policy. One of `encryption` or `network`.
 * The following arguments are optional:
 */
public data class ServerlessSecurityPolicyArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val policy: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.opensearch.ServerlessSecurityPolicyArgs> {
    override fun toJava(): com.pulumi.aws.opensearch.ServerlessSecurityPolicyArgs =
        com.pulumi.aws.opensearch.ServerlessSecurityPolicyArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServerlessSecurityPolicyArgs].
 */
@PulumiTagMarker
public class ServerlessSecurityPolicyArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var policy: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Description of the policy. Typically used to store information about the permissions defined in the policy.
     */
    @JvmName("urmecdejbvuvocub")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name of the policy.
     */
    @JvmName("ocodmhorsmeartpa")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value JSON policy document to use as the content for the new policy
     */
    @JvmName("rukppsiuepvpjaem")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value Type of security policy. One of `encryption` or `network`.
     * The following arguments are optional:
     */
    @JvmName("ohxurjtgjaggpcnj")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Description of the policy. Typically used to store information about the permissions defined in the policy.
     */
    @JvmName("ueirqctkgtjhqrrq")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name of the policy.
     */
    @JvmName("htwvtytektvmmbcl")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value JSON policy document to use as the content for the new policy
     */
    @JvmName("evskrwuwquxxabyp")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value Type of security policy. One of `encryption` or `network`.
     * The following arguments are optional:
     */
    @JvmName("itmcwcjyoywioxba")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ServerlessSecurityPolicyArgs = ServerlessSecurityPolicyArgs(
        description = description,
        name = name,
        policy = policy,
        type = type,
    )
}
