@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin

import com.pulumi.aws.opensearch.ServerlessVpcEndpointArgs.builder
import com.pulumi.aws.opensearch.kotlin.inputs.ServerlessVpcEndpointTimeoutsArgs
import com.pulumi.aws.opensearch.kotlin.inputs.ServerlessVpcEndpointTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS OpenSearchServerless VPC Endpoint.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opensearch.ServerlessVpcEndpoint;
 * import com.pulumi.aws.opensearch.ServerlessVpcEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ServerlessVpcEndpoint("example", ServerlessVpcEndpointArgs.builder()
 *             .subnetIds(aws_subnet.example().id())
 *             .vpcId(aws_vpc.example().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import OpenSearchServerless Vpc Endpointa using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:opensearch/serverlessVpcEndpoint:ServerlessVpcEndpoint example vpce-8012925589
 * ```
 * @property name Name of the interface endpoint.
 * @property securityGroupIds One or more security groups that define the ports, protocols, and sources for inbound traffic that you are authorizing into your endpoint. Up to 5 security groups can be provided.
 * @property subnetIds One or more subnet IDs from which you'll access OpenSearch Serverless. Up to 6 subnets can be provided.
 * @property timeouts
 * @property vpcId ID of the VPC from which you'll access OpenSearch Serverless.
 * The following arguments are optional:
 */
public data class ServerlessVpcEndpointArgs(
    public val name: Output<String>? = null,
    public val securityGroupIds: Output<List<String>>? = null,
    public val subnetIds: Output<List<String>>? = null,
    public val timeouts: Output<ServerlessVpcEndpointTimeoutsArgs>? = null,
    public val vpcId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.opensearch.ServerlessVpcEndpointArgs> {
    override fun toJava(): com.pulumi.aws.opensearch.ServerlessVpcEndpointArgs =
        com.pulumi.aws.opensearch.ServerlessVpcEndpointArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnetIds(subnetIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServerlessVpcEndpointArgs].
 */
@PulumiTagMarker
public class ServerlessVpcEndpointArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var securityGroupIds: Output<List<String>>? = null

    private var subnetIds: Output<List<String>>? = null

    private var timeouts: Output<ServerlessVpcEndpointTimeoutsArgs>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value Name of the interface endpoint.
     */
    @JvmName("ruetshfkiiphhvce")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value One or more security groups that define the ports, protocols, and sources for inbound traffic that you are authorizing into your endpoint. Up to 5 security groups can be provided.
     */
    @JvmName("isaiklylrtjaycmm")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("okhwvqpfnilvwxhp")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values One or more security groups that define the ports, protocols, and sources for inbound traffic that you are authorizing into your endpoint. Up to 5 security groups can be provided.
     */
    @JvmName("dwwlxpncepeaetlp")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value One or more subnet IDs from which you'll access OpenSearch Serverless. Up to 6 subnets can be provided.
     */
    @JvmName("cmcqbdkyudmdvtrl")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("syynjhorvdgcxwky")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values One or more subnet IDs from which you'll access OpenSearch Serverless. Up to 6 subnets can be provided.
     */
    @JvmName("bybjbfoqsjtrhelq")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("xmsddfbhracydifs")
    public suspend fun timeouts(`value`: Output<ServerlessVpcEndpointTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value ID of the VPC from which you'll access OpenSearch Serverless.
     * The following arguments are optional:
     */
    @JvmName("sorbijfiuahvuobl")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value Name of the interface endpoint.
     */
    @JvmName("ninhvwotoflltmhi")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value One or more security groups that define the ports, protocols, and sources for inbound traffic that you are authorizing into your endpoint. Up to 5 security groups can be provided.
     */
    @JvmName("nfcqdijtcrbvatcm")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values One or more security groups that define the ports, protocols, and sources for inbound traffic that you are authorizing into your endpoint. Up to 5 security groups can be provided.
     */
    @JvmName("rxmfxqllfaqjlptd")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value One or more subnet IDs from which you'll access OpenSearch Serverless. Up to 6 subnets can be provided.
     */
    @JvmName("ysoeiqmxkrdsyjyl")
    public suspend fun subnetIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values One or more subnet IDs from which you'll access OpenSearch Serverless. Up to 6 subnets can be provided.
     */
    @JvmName("ghhhxemtechyurtr")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value
     */
    @JvmName("pvpssmxaoknicqsy")
    public suspend fun timeouts(`value`: ServerlessVpcEndpointTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ginuhfceqlhkqnyh")
    public suspend
    fun timeouts(argument: suspend ServerlessVpcEndpointTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = ServerlessVpcEndpointTimeoutsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    /**
     * @param value ID of the VPC from which you'll access OpenSearch Serverless.
     * The following arguments are optional:
     */
    @JvmName("yuagnlfkuhviqvdx")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): ServerlessVpcEndpointArgs = ServerlessVpcEndpointArgs(
        name = name,
        securityGroupIds = securityGroupIds,
        subnetIds = subnetIds,
        timeouts = timeouts,
        vpcId = vpcId,
    )
}
