@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.inputs

import com.pulumi.aws.opensearch.inputs.DomainAutoTuneOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property desiredState Auto-Tune desired state for the domain. Valid values: `ENABLED` or `DISABLED`.
 * @property maintenanceSchedules Configuration block for Auto-Tune maintenance windows. Can be specified multiple times for each maintenance window. Detailed below.
 * @property rollbackOnDisable Whether to roll back to default Auto-Tune settings when disabling Auto-Tune. Valid values: `DEFAULT_ROLLBACK` or `NO_ROLLBACK`.
 */
public data class DomainAutoTuneOptionsArgs(
    public val desiredState: Output<String>,
    public val maintenanceSchedules: Output<List<DomainAutoTuneOptionsMaintenanceScheduleArgs>>? =
        null,
    public val rollbackOnDisable: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.opensearch.inputs.DomainAutoTuneOptionsArgs> {
    override fun toJava(): com.pulumi.aws.opensearch.inputs.DomainAutoTuneOptionsArgs =
        com.pulumi.aws.opensearch.inputs.DomainAutoTuneOptionsArgs.builder()
            .desiredState(desiredState.applyValue({ args0 -> args0 }))
            .maintenanceSchedules(
                maintenanceSchedules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .rollbackOnDisable(rollbackOnDisable?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainAutoTuneOptionsArgs].
 */
@PulumiTagMarker
public class DomainAutoTuneOptionsArgsBuilder internal constructor() {
    private var desiredState: Output<String>? = null

    private var maintenanceSchedules: Output<List<DomainAutoTuneOptionsMaintenanceScheduleArgs>>? =
        null

    private var rollbackOnDisable: Output<String>? = null

    /**
     * @param value Auto-Tune desired state for the domain. Valid values: `ENABLED` or `DISABLED`.
     */
    @JvmName("uyhpqiajhaothygc")
    public suspend fun desiredState(`value`: Output<String>) {
        this.desiredState = value
    }

    /**
     * @param value Configuration block for Auto-Tune maintenance windows. Can be specified multiple times for each maintenance window. Detailed below.
     */
    @JvmName("diwsyrrstjtkvuwq")
    public suspend
    fun maintenanceSchedules(`value`: Output<List<DomainAutoTuneOptionsMaintenanceScheduleArgs>>) {
        this.maintenanceSchedules = value
    }

    @JvmName("lxircypjeujgnlxw")
    public suspend fun maintenanceSchedules(
        vararg
        values: Output<DomainAutoTuneOptionsMaintenanceScheduleArgs>,
    ) {
        this.maintenanceSchedules = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for Auto-Tune maintenance windows. Can be specified multiple times for each maintenance window. Detailed below.
     */
    @JvmName("waxrrnbwyxvgxiyd")
    public suspend
    fun maintenanceSchedules(values: List<Output<DomainAutoTuneOptionsMaintenanceScheduleArgs>>) {
        this.maintenanceSchedules = Output.all(values)
    }

    /**
     * @param value Whether to roll back to default Auto-Tune settings when disabling Auto-Tune. Valid values: `DEFAULT_ROLLBACK` or `NO_ROLLBACK`.
     */
    @JvmName("xlrllelfjeppeusp")
    public suspend fun rollbackOnDisable(`value`: Output<String>) {
        this.rollbackOnDisable = value
    }

    /**
     * @param value Auto-Tune desired state for the domain. Valid values: `ENABLED` or `DISABLED`.
     */
    @JvmName("kasvnvlexuwlvekb")
    public suspend fun desiredState(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.desiredState = mapped
    }

    /**
     * @param value Configuration block for Auto-Tune maintenance windows. Can be specified multiple times for each maintenance window. Detailed below.
     */
    @JvmName("idxtiopfxjvulgvm")
    public suspend
    fun maintenanceSchedules(`value`: List<DomainAutoTuneOptionsMaintenanceScheduleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintenanceSchedules = mapped
    }

    /**
     * @param argument Configuration block for Auto-Tune maintenance windows. Can be specified multiple times for each maintenance window. Detailed below.
     */
    @JvmName("jnnqkdanqhecxrep")
    public suspend
    fun maintenanceSchedules(argument: List<suspend DomainAutoTuneOptionsMaintenanceScheduleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DomainAutoTuneOptionsMaintenanceScheduleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.maintenanceSchedules = mapped
    }

    /**
     * @param argument Configuration block for Auto-Tune maintenance windows. Can be specified multiple times for each maintenance window. Detailed below.
     */
    @JvmName("qiersxcbbdljuoyg")
    public suspend fun maintenanceSchedules(
        vararg
        argument: suspend DomainAutoTuneOptionsMaintenanceScheduleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DomainAutoTuneOptionsMaintenanceScheduleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.maintenanceSchedules = mapped
    }

    /**
     * @param argument Configuration block for Auto-Tune maintenance windows. Can be specified multiple times for each maintenance window. Detailed below.
     */
    @JvmName("vimsrhftvhnsimyl")
    public suspend
    fun maintenanceSchedules(argument: suspend DomainAutoTuneOptionsMaintenanceScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DomainAutoTuneOptionsMaintenanceScheduleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.maintenanceSchedules = mapped
    }

    /**
     * @param values Configuration block for Auto-Tune maintenance windows. Can be specified multiple times for each maintenance window. Detailed below.
     */
    @JvmName("cwtxmgnqvqchtoxm")
    public suspend fun maintenanceSchedules(
        vararg
        values: DomainAutoTuneOptionsMaintenanceScheduleArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maintenanceSchedules = mapped
    }

    /**
     * @param value Whether to roll back to default Auto-Tune settings when disabling Auto-Tune. Valid values: `DEFAULT_ROLLBACK` or `NO_ROLLBACK`.
     */
    @JvmName("oemwnhmchymmsctn")
    public suspend fun rollbackOnDisable(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rollbackOnDisable = mapped
    }

    internal fun build(): DomainAutoTuneOptionsArgs = DomainAutoTuneOptionsArgs(
        desiredState = desiredState ?: throw PulumiNullFieldException("desiredState"),
        maintenanceSchedules = maintenanceSchedules,
        rollbackOnDisable = rollbackOnDisable,
    )
}
