@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.inputs

import com.pulumi.aws.opensearch.inputs.DomainClusterConfigZoneAwarenessConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property availabilityZoneCount Number of Availability Zones for the domain to use with `zone_awareness_enabled`. Defaults to `2`. Valid values: `2` or `3`.
 */
public data class DomainClusterConfigZoneAwarenessConfigArgs(
    public val availabilityZoneCount: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.opensearch.inputs.DomainClusterConfigZoneAwarenessConfigArgs> {
    override fun toJava(): com.pulumi.aws.opensearch.inputs.DomainClusterConfigZoneAwarenessConfigArgs =
        com.pulumi.aws.opensearch.inputs.DomainClusterConfigZoneAwarenessConfigArgs.builder()
            .availabilityZoneCount(availabilityZoneCount?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainClusterConfigZoneAwarenessConfigArgs].
 */
@PulumiTagMarker
public class DomainClusterConfigZoneAwarenessConfigArgsBuilder internal constructor() {
    private var availabilityZoneCount: Output<Int>? = null

    /**
     * @param value Number of Availability Zones for the domain to use with `zone_awareness_enabled`. Defaults to `2`. Valid values: `2` or `3`.
     */
    @JvmName("rjhqqwmkbmebddfh")
    public suspend fun availabilityZoneCount(`value`: Output<Int>) {
        this.availabilityZoneCount = value
    }

    /**
     * @param value Number of Availability Zones for the domain to use with `zone_awareness_enabled`. Defaults to `2`. Valid values: `2` or `3`.
     */
    @JvmName("ygdhlabmokeitsjf")
    public suspend fun availabilityZoneCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZoneCount = mapped
    }

    internal fun build(): DomainClusterConfigZoneAwarenessConfigArgs =
        DomainClusterConfigZoneAwarenessConfigArgs(
            availabilityZoneCount = availabilityZoneCount,
        )
}
