@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.inputs

import com.pulumi.aws.opensearch.inputs.DomainLogPublishingOptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cloudwatchLogGroupArn ARN of the Cloudwatch log group to which log needs to be published.
 * @property enabled Whether given log publishing option is enabled or not.
 * @property logType Type of OpenSearch log. Valid values: `INDEX_SLOW_LOGS`, `SEARCH_SLOW_LOGS`, `ES_APPLICATION_LOGS`, `AUDIT_LOGS`.
 */
public data class DomainLogPublishingOptionArgs(
    public val cloudwatchLogGroupArn: Output<String>,
    public val enabled: Output<Boolean>? = null,
    public val logType: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.opensearch.inputs.DomainLogPublishingOptionArgs> {
    override fun toJava(): com.pulumi.aws.opensearch.inputs.DomainLogPublishingOptionArgs =
        com.pulumi.aws.opensearch.inputs.DomainLogPublishingOptionArgs.builder()
            .cloudwatchLogGroupArn(cloudwatchLogGroupArn.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .logType(logType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainLogPublishingOptionArgs].
 */
@PulumiTagMarker
public class DomainLogPublishingOptionArgsBuilder internal constructor() {
    private var cloudwatchLogGroupArn: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var logType: Output<String>? = null

    /**
     * @param value ARN of the Cloudwatch log group to which log needs to be published.
     */
    @JvmName("lsdxaqyrufibjlov")
    public suspend fun cloudwatchLogGroupArn(`value`: Output<String>) {
        this.cloudwatchLogGroupArn = value
    }

    /**
     * @param value Whether given log publishing option is enabled or not.
     */
    @JvmName("xypstpmiexcikbns")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Type of OpenSearch log. Valid values: `INDEX_SLOW_LOGS`, `SEARCH_SLOW_LOGS`, `ES_APPLICATION_LOGS`, `AUDIT_LOGS`.
     */
    @JvmName("lailmuqyjmqjnhav")
    public suspend fun logType(`value`: Output<String>) {
        this.logType = value
    }

    /**
     * @param value ARN of the Cloudwatch log group to which log needs to be published.
     */
    @JvmName("isoctismerpddlmh")
    public suspend fun cloudwatchLogGroupArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cloudwatchLogGroupArn = mapped
    }

    /**
     * @param value Whether given log publishing option is enabled or not.
     */
    @JvmName("xwjlichmgrptgiiw")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Type of OpenSearch log. Valid values: `INDEX_SLOW_LOGS`, `SEARCH_SLOW_LOGS`, `ES_APPLICATION_LOGS`, `AUDIT_LOGS`.
     */
    @JvmName("mpevvmqgsqlrmkdd")
    public suspend fun logType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logType = mapped
    }

    internal fun build(): DomainLogPublishingOptionArgs = DomainLogPublishingOptionArgs(
        cloudwatchLogGroupArn = cloudwatchLogGroupArn ?: throw
            PulumiNullFieldException("cloudwatchLogGroupArn"),
        enabled = enabled,
        logType = logType ?: throw PulumiNullFieldException("logType"),
    )
}
