@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.inputs

import com.pulumi.aws.opensearch.inputs.DomainSamlOptionsSamlOptionsIdpArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property entityId Unique Entity ID of the application in SAML Identity Provider.
 * @property metadataContent Metadata of the SAML application in xml format.
 */
public data class DomainSamlOptionsSamlOptionsIdpArgs(
    public val entityId: Output<String>,
    public val metadataContent: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.opensearch.inputs.DomainSamlOptionsSamlOptionsIdpArgs> {
    override fun toJava(): com.pulumi.aws.opensearch.inputs.DomainSamlOptionsSamlOptionsIdpArgs =
        com.pulumi.aws.opensearch.inputs.DomainSamlOptionsSamlOptionsIdpArgs.builder()
            .entityId(entityId.applyValue({ args0 -> args0 }))
            .metadataContent(metadataContent.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainSamlOptionsSamlOptionsIdpArgs].
 */
@PulumiTagMarker
public class DomainSamlOptionsSamlOptionsIdpArgsBuilder internal constructor() {
    private var entityId: Output<String>? = null

    private var metadataContent: Output<String>? = null

    /**
     * @param value Unique Entity ID of the application in SAML Identity Provider.
     */
    @JvmName("mxxewmvhojurrwkg")
    public suspend fun entityId(`value`: Output<String>) {
        this.entityId = value
    }

    /**
     * @param value Metadata of the SAML application in xml format.
     */
    @JvmName("hohlvhkstdtmgncl")
    public suspend fun metadataContent(`value`: Output<String>) {
        this.metadataContent = value
    }

    /**
     * @param value Unique Entity ID of the application in SAML Identity Provider.
     */
    @JvmName("wwbfluckdxokengo")
    public suspend fun entityId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.entityId = mapped
    }

    /**
     * @param value Metadata of the SAML application in xml format.
     */
    @JvmName("bquomcmeefayvusw")
    public suspend fun metadataContent(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metadataContent = mapped
    }

    internal fun build(): DomainSamlOptionsSamlOptionsIdpArgs = DomainSamlOptionsSamlOptionsIdpArgs(
        entityId = entityId ?: throw PulumiNullFieldException("entityId"),
        metadataContent = metadataContent ?: throw PulumiNullFieldException("metadataContent"),
    )
}
