@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.inputs

import com.pulumi.aws.opensearch.inputs.DomainSnapshotOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property automatedSnapshotStartHour Hour during which the service takes an automated daily snapshot of the indices in the domain.
 */
public data class DomainSnapshotOptionsArgs(
    public val automatedSnapshotStartHour: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.opensearch.inputs.DomainSnapshotOptionsArgs> {
    override fun toJava(): com.pulumi.aws.opensearch.inputs.DomainSnapshotOptionsArgs =
        com.pulumi.aws.opensearch.inputs.DomainSnapshotOptionsArgs.builder()
            .automatedSnapshotStartHour(automatedSnapshotStartHour.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainSnapshotOptionsArgs].
 */
@PulumiTagMarker
public class DomainSnapshotOptionsArgsBuilder internal constructor() {
    private var automatedSnapshotStartHour: Output<Int>? = null

    /**
     * @param value Hour during which the service takes an automated daily snapshot of the indices in the domain.
     */
    @JvmName("kyopabbnvfgnjrts")
    public suspend fun automatedSnapshotStartHour(`value`: Output<Int>) {
        this.automatedSnapshotStartHour = value
    }

    /**
     * @param value Hour during which the service takes an automated daily snapshot of the indices in the domain.
     */
    @JvmName("gjwfknhluvtwqjne")
    public suspend fun automatedSnapshotStartHour(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.automatedSnapshotStartHour = mapped
    }

    internal fun build(): DomainSnapshotOptionsArgs = DomainSnapshotOptionsArgs(
        automatedSnapshotStartHour = automatedSnapshotStartHour ?: throw
            PulumiNullFieldException("automatedSnapshotStartHour"),
    )
}
