@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.inputs

import com.pulumi.aws.opensearch.inputs.DomainSoftwareUpdateOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property autoSoftwareUpdateEnabled Whether automatic service software updates are enabled for the domain. Defaults to `false`.
 */
public data class DomainSoftwareUpdateOptionsArgs(
    public val autoSoftwareUpdateEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.opensearch.inputs.DomainSoftwareUpdateOptionsArgs> {
    override fun toJava(): com.pulumi.aws.opensearch.inputs.DomainSoftwareUpdateOptionsArgs =
        com.pulumi.aws.opensearch.inputs.DomainSoftwareUpdateOptionsArgs.builder()
            .autoSoftwareUpdateEnabled(autoSoftwareUpdateEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainSoftwareUpdateOptionsArgs].
 */
@PulumiTagMarker
public class DomainSoftwareUpdateOptionsArgsBuilder internal constructor() {
    private var autoSoftwareUpdateEnabled: Output<Boolean>? = null

    /**
     * @param value Whether automatic service software updates are enabled for the domain. Defaults to `false`.
     */
    @JvmName("pibmlrlejynadlrp")
    public suspend fun autoSoftwareUpdateEnabled(`value`: Output<Boolean>) {
        this.autoSoftwareUpdateEnabled = value
    }

    /**
     * @param value Whether automatic service software updates are enabled for the domain. Defaults to `false`.
     */
    @JvmName("cmlwtdqpfacvrupm")
    public suspend fun autoSoftwareUpdateEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoSoftwareUpdateEnabled = mapped
    }

    internal fun build(): DomainSoftwareUpdateOptionsArgs = DomainSoftwareUpdateOptionsArgs(
        autoSoftwareUpdateEnabled = autoSoftwareUpdateEnabled,
    )
}
