@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.inputs

import com.pulumi.aws.opensearch.inputs.GetDomainOffPeakWindowOptionsOffPeakWindow.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property windowStartTimes 10h window for updates
 */
public data class GetDomainOffPeakWindowOptionsOffPeakWindow(
    public val windowStartTimes: List<GetDomainOffPeakWindowOptionsOffPeakWindowWindowStartTime>,
) : ConvertibleToJava<com.pulumi.aws.opensearch.inputs.GetDomainOffPeakWindowOptionsOffPeakWindow> {
    override fun toJava(): com.pulumi.aws.opensearch.inputs.GetDomainOffPeakWindowOptionsOffPeakWindow =
        com.pulumi.aws.opensearch.inputs.GetDomainOffPeakWindowOptionsOffPeakWindow.builder()
            .windowStartTimes(
                windowStartTimes.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [GetDomainOffPeakWindowOptionsOffPeakWindow].
 */
@PulumiTagMarker
public class GetDomainOffPeakWindowOptionsOffPeakWindowBuilder internal constructor() {
    private var windowStartTimes: List<GetDomainOffPeakWindowOptionsOffPeakWindowWindowStartTime>? =
        null

    /**
     * @param value 10h window for updates
     */
    @JvmName("mdfwwqrjthgybmwt")
    public suspend
    fun windowStartTimes(`value`: List<GetDomainOffPeakWindowOptionsOffPeakWindowWindowStartTime>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.windowStartTimes = mapped
    }

    /**
     * @param argument 10h window for updates
     */
    @JvmName("abpdxrtydlyvmxct")
    public suspend
    fun windowStartTimes(argument: List<suspend GetDomainOffPeakWindowOptionsOffPeakWindowWindowStartTimeBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetDomainOffPeakWindowOptionsOffPeakWindowWindowStartTimeBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.windowStartTimes = mapped
    }

    /**
     * @param argument 10h window for updates
     */
    @JvmName("pxeqsfrdtllseikw")
    public suspend fun windowStartTimes(
        vararg
        argument: suspend GetDomainOffPeakWindowOptionsOffPeakWindowWindowStartTimeBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            GetDomainOffPeakWindowOptionsOffPeakWindowWindowStartTimeBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.windowStartTimes = mapped
    }

    /**
     * @param argument 10h window for updates
     */
    @JvmName("imgtcgyabcstqdvk")
    public suspend
    fun windowStartTimes(argument: suspend GetDomainOffPeakWindowOptionsOffPeakWindowWindowStartTimeBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                GetDomainOffPeakWindowOptionsOffPeakWindowWindowStartTimeBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = toBeMapped
        this.windowStartTimes = mapped
    }

    /**
     * @param values 10h window for updates
     */
    @JvmName("ewtbwlowakdrsbsx")
    public suspend fun windowStartTimes(
        vararg
        values: GetDomainOffPeakWindowOptionsOffPeakWindowWindowStartTime,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.windowStartTimes = mapped
    }

    internal fun build(): GetDomainOffPeakWindowOptionsOffPeakWindow =
        GetDomainOffPeakWindowOptionsOffPeakWindow(
            windowStartTimes = windowStartTimes ?: throw PulumiNullFieldException("windowStartTimes"),
        )
}
