@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.inputs

import com.pulumi.aws.opensearch.inputs.GetDomainOffPeakWindowOptionsOffPeakWindowWindowStartTime.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property hours Starting hour of the 10-hour window for updates
 * @property minutes Starting minute of the 10-hour window for updates
 */
public data class GetDomainOffPeakWindowOptionsOffPeakWindowWindowStartTime(
    public val hours: Int,
    public val minutes: Int,
) :
    ConvertibleToJava<com.pulumi.aws.opensearch.inputs.GetDomainOffPeakWindowOptionsOffPeakWindowWindowStartTime> {
    override fun toJava():
        com.pulumi.aws.opensearch.inputs.GetDomainOffPeakWindowOptionsOffPeakWindowWindowStartTime =
        com.pulumi.aws.opensearch.inputs.GetDomainOffPeakWindowOptionsOffPeakWindowWindowStartTime.builder()
            .hours(hours.let({ args0 -> args0 }))
            .minutes(minutes.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDomainOffPeakWindowOptionsOffPeakWindowWindowStartTime].
 */
@PulumiTagMarker
public class GetDomainOffPeakWindowOptionsOffPeakWindowWindowStartTimeBuilder internal constructor() {
    private var hours: Int? = null

    private var minutes: Int? = null

    /**
     * @param value Starting hour of the 10-hour window for updates
     */
    @JvmName("fxeqnigukkirrioc")
    public suspend fun hours(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.hours = mapped
    }

    /**
     * @param value Starting minute of the 10-hour window for updates
     */
    @JvmName("xqyjtcacslicpfnj")
    public suspend fun minutes(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.minutes = mapped
    }

    internal fun build(): GetDomainOffPeakWindowOptionsOffPeakWindowWindowStartTime =
        GetDomainOffPeakWindowOptionsOffPeakWindowWindowStartTime(
            hours = hours ?: throw PulumiNullFieldException("hours"),
            minutes = minutes ?: throw PulumiNullFieldException("minutes"),
        )
}
