@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.inputs

import com.pulumi.aws.opensearch.inputs.GetDomainPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDomain.
 * @property domainName Name of the domain.
 * @property offPeakWindowOptions Off Peak update options
 * @property tags Tags assigned to the domain.
 */
public data class GetDomainPlainArgs(
    public val domainName: String,
    public val offPeakWindowOptions: GetDomainOffPeakWindowOptions? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.opensearch.inputs.GetDomainPlainArgs> {
    override fun toJava(): com.pulumi.aws.opensearch.inputs.GetDomainPlainArgs =
        com.pulumi.aws.opensearch.inputs.GetDomainPlainArgs.builder()
            .domainName(domainName.let({ args0 -> args0 }))
            .offPeakWindowOptions(offPeakWindowOptions?.let({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetDomainPlainArgs].
 */
@PulumiTagMarker
public class GetDomainPlainArgsBuilder internal constructor() {
    private var domainName: String? = null

    private var offPeakWindowOptions: GetDomainOffPeakWindowOptions? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Name of the domain.
     */
    @JvmName("uhuwvcydokulcnyd")
    public suspend fun domainName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.domainName = mapped
    }

    /**
     * @param value Off Peak update options
     */
    @JvmName("ormomwjvaxkqxcki")
    public suspend fun offPeakWindowOptions(`value`: GetDomainOffPeakWindowOptions?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.offPeakWindowOptions = mapped
    }

    /**
     * @param argument Off Peak update options
     */
    @JvmName("iliwjpmyadfxnjjw")
    public suspend
    fun offPeakWindowOptions(argument: suspend GetDomainOffPeakWindowOptionsBuilder.() -> Unit) {
        val toBeMapped = GetDomainOffPeakWindowOptionsBuilder().applySuspend { argument() }.build()
        val mapped = toBeMapped
        this.offPeakWindowOptions = mapped
    }

    /**
     * @param value Tags assigned to the domain.
     */
    @JvmName("kvsvmidqkurdpnlg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Tags assigned to the domain.
     */
    @JvmName("kjnedleawypeupud")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetDomainPlainArgs = GetDomainPlainArgs(
        domainName = domainName ?: throw PulumiNullFieldException("domainName"),
        offPeakWindowOptions = offPeakWindowOptions,
        tags = tags,
    )
}
