@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.inputs

import com.pulumi.aws.opensearch.inputs.GetServerlessSecurityConfigPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getServerlessSecurityConfig.
 * @property id The unique identifier of the security configuration.
 * @property samlOptions SAML options for the security configuration.
 */
public data class GetServerlessSecurityConfigPlainArgs(
    public val id: String,
    public val samlOptions: GetServerlessSecurityConfigSamlOptions? = null,
) : ConvertibleToJava<com.pulumi.aws.opensearch.inputs.GetServerlessSecurityConfigPlainArgs> {
    override fun toJava(): com.pulumi.aws.opensearch.inputs.GetServerlessSecurityConfigPlainArgs =
        com.pulumi.aws.opensearch.inputs.GetServerlessSecurityConfigPlainArgs.builder()
            .id(id.let({ args0 -> args0 }))
            .samlOptions(samlOptions?.let({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [GetServerlessSecurityConfigPlainArgs].
 */
@PulumiTagMarker
public class GetServerlessSecurityConfigPlainArgsBuilder internal constructor() {
    private var id: String? = null

    private var samlOptions: GetServerlessSecurityConfigSamlOptions? = null

    /**
     * @param value The unique identifier of the security configuration.
     */
    @JvmName("pmtrnndsricisyfi")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value SAML options for the security configuration.
     */
    @JvmName("fijpjxntntkrnykd")
    public suspend fun samlOptions(`value`: GetServerlessSecurityConfigSamlOptions?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.samlOptions = mapped
    }

    /**
     * @param argument SAML options for the security configuration.
     */
    @JvmName("aecbxkfqowuymnni")
    public suspend
    fun samlOptions(argument: suspend GetServerlessSecurityConfigSamlOptionsBuilder.() -> Unit) {
        val toBeMapped = GetServerlessSecurityConfigSamlOptionsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = toBeMapped
        this.samlOptions = mapped
    }

    internal fun build(): GetServerlessSecurityConfigPlainArgs = GetServerlessSecurityConfigPlainArgs(
        id = id ?: throw PulumiNullFieldException("id"),
        samlOptions = samlOptions,
    )
}
