@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.inputs

import com.pulumi.aws.opensearch.inputs.GetServerlessSecurityConfigSamlOptions.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property groupAttribute Group attribute for this SAML integration.
 * @property metadata The XML IdP metadata file generated from your identity provider.
 * @property sessionTimeout Session timeout, in minutes. Minimum is 5 minutes and maximum is 720 minutes (12 hours). Default is 60 minutes.
 * @property userAttribute User attribute for this SAML integration.
 */
public data class GetServerlessSecurityConfigSamlOptions(
    public val groupAttribute: String,
    public val metadata: String,
    public val sessionTimeout: Int,
    public val userAttribute: String,
) : ConvertibleToJava<com.pulumi.aws.opensearch.inputs.GetServerlessSecurityConfigSamlOptions> {
    override fun toJava(): com.pulumi.aws.opensearch.inputs.GetServerlessSecurityConfigSamlOptions =
        com.pulumi.aws.opensearch.inputs.GetServerlessSecurityConfigSamlOptions.builder()
            .groupAttribute(groupAttribute.let({ args0 -> args0 }))
            .metadata(metadata.let({ args0 -> args0 }))
            .sessionTimeout(sessionTimeout.let({ args0 -> args0 }))
            .userAttribute(userAttribute.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServerlessSecurityConfigSamlOptions].
 */
@PulumiTagMarker
public class GetServerlessSecurityConfigSamlOptionsBuilder internal constructor() {
    private var groupAttribute: String? = null

    private var metadata: String? = null

    private var sessionTimeout: Int? = null

    private var userAttribute: String? = null

    /**
     * @param value Group attribute for this SAML integration.
     */
    @JvmName("vsrpccdsnvvyogay")
    public suspend fun groupAttribute(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.groupAttribute = mapped
    }

    /**
     * @param value The XML IdP metadata file generated from your identity provider.
     */
    @JvmName("ntfepxguoiqvaqrs")
    public suspend fun metadata(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.metadata = mapped
    }

    /**
     * @param value Session timeout, in minutes. Minimum is 5 minutes and maximum is 720 minutes (12 hours). Default is 60 minutes.
     */
    @JvmName("tqlevwmgsyjmuoto")
    public suspend fun sessionTimeout(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sessionTimeout = mapped
    }

    /**
     * @param value User attribute for this SAML integration.
     */
    @JvmName("igtdfvycgufxuvdx")
    public suspend fun userAttribute(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.userAttribute = mapped
    }

    internal fun build(): GetServerlessSecurityConfigSamlOptions =
        GetServerlessSecurityConfigSamlOptions(
            groupAttribute = groupAttribute ?: throw PulumiNullFieldException("groupAttribute"),
            metadata = metadata ?: throw PulumiNullFieldException("metadata"),
            sessionTimeout = sessionTimeout ?: throw PulumiNullFieldException("sessionTimeout"),
            userAttribute = userAttribute ?: throw PulumiNullFieldException("userAttribute"),
        )
}
