@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.inputs

import com.pulumi.aws.opensearch.inputs.GetServerlessSecurityPolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getServerlessSecurityPolicy.
 * @property name Name of the policy
 * @property type Type of security policy. One of `encryption` or `network`.
 */
public data class GetServerlessSecurityPolicyPlainArgs(
    public val name: String,
    public val type: String,
) : ConvertibleToJava<com.pulumi.aws.opensearch.inputs.GetServerlessSecurityPolicyPlainArgs> {
    override fun toJava(): com.pulumi.aws.opensearch.inputs.GetServerlessSecurityPolicyPlainArgs =
        com.pulumi.aws.opensearch.inputs.GetServerlessSecurityPolicyPlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .type(type.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServerlessSecurityPolicyPlainArgs].
 */
@PulumiTagMarker
public class GetServerlessSecurityPolicyPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var type: String? = null

    /**
     * @param value Name of the policy
     */
    @JvmName("bmlxgbhjvegjdksj")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Type of security policy. One of `encryption` or `network`.
     */
    @JvmName("bjqceokckuleaxis")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.type = mapped
    }

    internal fun build(): GetServerlessSecurityPolicyPlainArgs = GetServerlessSecurityPolicyPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
