@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.inputs

import com.pulumi.aws.opensearch.inputs.OutboundConnectionConnectionPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property crossClusterSearch Configuration block for cross cluster search.
 * @property endpoint The endpoint of the remote domain, is only set when `connection_mode` is `VPC_ENDPOINT` and `accept_connection` is `TRUE`.
 */
public data class OutboundConnectionConnectionPropertiesArgs(
    public val crossClusterSearch:
    Output<OutboundConnectionConnectionPropertiesCrossClusterSearchArgs>? = null,
    public val endpoint: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.opensearch.inputs.OutboundConnectionConnectionPropertiesArgs> {
    override fun toJava(): com.pulumi.aws.opensearch.inputs.OutboundConnectionConnectionPropertiesArgs =
        com.pulumi.aws.opensearch.inputs.OutboundConnectionConnectionPropertiesArgs.builder()
            .crossClusterSearch(
                crossClusterSearch?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .endpoint(endpoint?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OutboundConnectionConnectionPropertiesArgs].
 */
@PulumiTagMarker
public class OutboundConnectionConnectionPropertiesArgsBuilder internal constructor() {
    private var crossClusterSearch:
        Output<OutboundConnectionConnectionPropertiesCrossClusterSearchArgs>? = null

    private var endpoint: Output<String>? = null

    /**
     * @param value Configuration block for cross cluster search.
     */
    @JvmName("mokufctjxvwlxqoc")
    public suspend
    fun crossClusterSearch(`value`: Output<OutboundConnectionConnectionPropertiesCrossClusterSearchArgs>) {
        this.crossClusterSearch = value
    }

    /**
     * @param value The endpoint of the remote domain, is only set when `connection_mode` is `VPC_ENDPOINT` and `accept_connection` is `TRUE`.
     */
    @JvmName("ovgihqhsdooevhkj")
    public suspend fun endpoint(`value`: Output<String>) {
        this.endpoint = value
    }

    /**
     * @param value Configuration block for cross cluster search.
     */
    @JvmName("vpuudxqpivsytpla")
    public suspend
    fun crossClusterSearch(`value`: OutboundConnectionConnectionPropertiesCrossClusterSearchArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.crossClusterSearch = mapped
    }

    /**
     * @param argument Configuration block for cross cluster search.
     */
    @JvmName("hmlpcbwtrfuimskc")
    public suspend
    fun crossClusterSearch(argument: suspend OutboundConnectionConnectionPropertiesCrossClusterSearchArgsBuilder.() -> Unit) {
        val toBeMapped =
            OutboundConnectionConnectionPropertiesCrossClusterSearchArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.crossClusterSearch = mapped
    }

    /**
     * @param value The endpoint of the remote domain, is only set when `connection_mode` is `VPC_ENDPOINT` and `accept_connection` is `TRUE`.
     */
    @JvmName("gohwhjhkcbyfxujm")
    public suspend fun endpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    internal fun build(): OutboundConnectionConnectionPropertiesArgs =
        OutboundConnectionConnectionPropertiesArgs(
            crossClusterSearch = crossClusterSearch,
            endpoint = endpoint,
        )
}
